package cn.allbs.captcha.captcha;

import cn.allbs.captcha.core.AbstractCaptcha;
import cn.allbs.captcha.core.CaptchaDetails;
import cn.allbs.captcha.enums.ColorEnum;
import cn.allbs.captcha.generator.NumberCountCaptchaGenerator;
import cn.allbs.captcha.utils.GifEncoder;
import cn.allbs.captcha.utils.InterferingUtil;
import com.googlecode.aviator.AviatorEvaluator;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;

/**
 * 数字计算验证码
 *
 * @author ChenQi
 */
public class NumberCountCaptcha extends AbstractCaptcha {
    public NumberCountCaptcha(int width, int height, int len) {
        super(width, height, new NumberCountCaptchaGenerator(len), 15, len);
    }

    public NumberCountCaptcha(CaptchaDetails captchaDetails) {
        super(captchaDetails, new NumberCountCaptchaGenerator(captchaDetails.len()));
    }

    @Override
    protected Image createImage(char[] code) {
        BufferedImage bi = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        Graphics2D g2d = (Graphics2D) bi.getGraphics();
        // 填充背景
        g2d.setColor(background);
        g2d.fillRect(0, 0, width, height);
        // 抗锯齿
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        // 画干扰圆
        InterferingUtil.drawOval(2, g2d, width, height);
        // 画字符串
        g2d.setFont(font);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        // 每一个字符所占的宽度
        int fW = width / code.length;
        // 字符的左右边距
        int fSp = (fW - (int) fontMetrics.getStringBounds("8", g2d).getWidth()) / 2;
        for (int i = 0; i < code.length; i++) {
            g2d.setColor(ColorEnum.color());
            // 文字的纵坐标
            int fY = height
                    - ((height - (int) fontMetrics.getStringBounds(String.valueOf(code[i]), g2d).getHeight()) >> 1);
            g2d.drawString(String.valueOf(code[i]), i * fW + fSp + 3, fY - 3);
        }
        g2d.dispose();
        return bi;
    }

    @Override
    protected void createImageGif(char[] code) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        // 随机生成每个文字的颜色
        Color fontColor[] = new Color[code.length];
        for (int i = 0; i < code.length; i++) {
            fontColor[i] = ColorEnum.color();
        }
        // 随机生成贝塞尔曲线参数
        int x1 = 5, y1 = num(5, height / 2);
        int x2 = width - 5, y2 = num(height / 2, height - 5);
        int ctrlx = num(width / 4, width / 4 * 3), ctrly = num(5, height - 5);
        if (num(2) == 0) {
            int ty = y1;
            y1 = y2;
            y2 = ty;
        }
        int ctrlx1 = num(width / 4, width / 4 * 3), ctrly1 = num(5, height - 5);
        int[][] besselXY = new int[][]{{x1, y1}, {ctrlx, ctrly}, {ctrlx1, ctrly1}, {x2, y2}};
        // 开始画gif每一帧
        GifEncoder gifEncoder = new GifEncoder();
        gifEncoder.setQuality(180);
        gifEncoder.setDelay(100);
        gifEncoder.setRepeat(0);
        gifEncoder.start(out);
        for (int i = 0; i < code.length; i++) {
            BufferedImage frame = graphicsImage(fontColor, code, i, besselXY);
            gifEncoder.addFrame(frame);
            frame.flush();
        }
        gifEncoder.finish();
        this.imageBytes = out.toByteArray();
    }

    @Override
    protected void generateCode() {
        this.codeChar = generator.generator();
        this.code = String.valueOf(AviatorEvaluator.execute(String.valueOf(codeChar).replace("x", "*").replace("=?", "")));
    }
}
