package cn.allbs.captcha.core;

import java.awt.*;
import java.io.Serializable;

/**
 * 验证码属性
 *
 * @author ChenQi
 */
public interface CaptchaDetails extends Serializable {

    /**
     * 验证码默认长度
     *
     * @return 默认长度
     */
    int len();

    /**
     * 验证码默认宽度
     *
     * @return 默认宽度
     */
    int width();

    /**
     * 验证码默认高度
     *
     * @return 默认高度
     */
    int height();

    /**
     * 验证码字体类型
     *
     * @return 字体类型
     */
    Font font();

    /**
     * 当前验证码背景色
     *
     * @return 颜色
     */
    Color color();

    /**
     * 验证码类型
     */
    int type();

    /**
     * 干扰数
     *
     * @return 干扰素
     */
    int interfereCount();

    /**
     * 图片类型
     *
     * @return 图片类型
     */
    int imageType();
}
