package cn.allbs.captcha.enums;

import cn.hutool.core.util.RandomUtil;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.awt.*;

/**
 * @author ChenQi
 */
@Getter
@RequiredArgsConstructor
public enum ColorEnum {

    COLOR1(0, 135, 255),

    COLOR2(51, 153, 51),

    COLOR3(255, 102, 102),

    COLOR4(255, 153, 0),

    COLOR5(153, 102, 0),

    COLOR6(153, 102, 153),

    COLOR7(51, 153, 153),

    COLOR8(102, 102, 255),

    COLOR9(0, 102, 204),

    COLOR10(204, 51, 51),

    COLOR11(0, 153, 204),

    COLOR12(0, 51, 102);

    ColorEnum(int... color) {
        this.color = color;
    }

    private int[] color;

    /**
     * 给定范围获得随机颜色
     *
     * @param fc 0-255
     * @param bc 0-255
     * @return 随机颜色
     */
    public static Color color(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }

        if (bc > 255) {
            bc = 255;
        }
        int r = fc + RandomUtil.randomInt(bc - fc);
        int g = fc + RandomUtil.randomInt(bc - fc);
        int b = fc + RandomUtil.randomInt(bc - fc);
        return new Color(r, g, b);
    }

    /**
     * 获取随机常用颜色
     *
     * @return 随机颜色
     */
    public static Color color() {
        ColorEnum[] colorEnums = ColorEnum.values();
        int[] color = colorEnums[RandomUtil.randomInt(0, colorEnums.length)].color;
        return new Color(color[0], color[1], color[2]);
    }
}
