/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.captcha.generator;

import cn.allbs.captcha.enums.AlphaEnum;
import cn.allbs.captcha.generator.AbstractCaptchaGenerator;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;

public class NumberCaptchaGenerator
extends AbstractCaptchaGenerator {
    public NumberCaptchaGenerator(char[] baseChars, int len) {
        super(baseChars, len);
    }

    public NumberCaptchaGenerator(int len) {
        super(AlphaEnum.NUMBERS.getAlphas(), len);
    }

    @Override
    public char[] generator() {
        char[] codes = new char[this.len];
        for (int i = 0; i < this.len; ++i) {
            codes[i] = this.baseChars[RandomUtil.randomInt((int)this.baseChars.length)];
        }
        return codes;
    }

    @Override
    public boolean verify(String generatorCode, String checkedCode) {
        if (StrUtil.isAllNotBlank((CharSequence[])new CharSequence[]{generatorCode, checkedCode})) {
            return StrUtil.equalsIgnoreCase((CharSequence)generatorCode, (CharSequence)checkedCode);
        }
        return false;
    }
}

