/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.captcha.core;

import cn.allbs.captcha.core.CaptchaDetails;
import cn.allbs.captcha.core.ICaptcha;
import cn.allbs.captcha.enums.ImageEnum;
import cn.allbs.captcha.generator.CaptchaGenerator;
import cn.allbs.captcha.utils.InterferingUtil;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.URLUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.CubicCurve2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractCaptcha
implements ICaptcha {
    protected int width;
    protected int height;
    protected int interfereCount;
    protected Font font;
    protected String code;
    protected byte[] imageBytes;
    protected CaptchaGenerator generator;
    protected Color background;
    protected AlphaComposite textAlpha;
    protected int len;
    protected Color color;
    protected char[] codeChar;
    protected int imageType;
    protected String mimeType;

    public AbstractCaptcha(int width, int height, CaptchaGenerator generator, int interfereCount, int len) {
        this.width = width;
        this.height = height;
        this.generator = generator;
        this.interfereCount = interfereCount;
        this.len = len;
        this.font = new Font("SansSerif", 0, (int)((double)this.height * 0.75));
    }

    public AbstractCaptcha(int width, int height, CaptchaGenerator generator, int interfereCount, int len, Font font) {
        this.width = width;
        this.height = height;
        this.generator = generator;
        this.interfereCount = interfereCount;
        this.len = len;
        this.font = font;
    }

    public AbstractCaptcha(CaptchaDetails captchaDetails) {
        this.width = captchaDetails.width();
        this.height = captchaDetails.height();
        this.len = captchaDetails.len();
        this.font = captchaDetails.font();
        this.interfereCount = captchaDetails.interfereCount();
    }

    public AbstractCaptcha(CaptchaDetails captchaDetails, CaptchaGenerator generator) {
        this.width = captchaDetails.width();
        this.height = captchaDetails.height();
        this.len = captchaDetails.len();
        this.font = captchaDetails.font();
        this.interfereCount = captchaDetails.interfereCount();
        this.imageType = captchaDetails.imageType();
        this.background = captchaDetails.color();
        this.generator = generator;
    }

    @Override
    public void create() {
        ByteArrayOutputStream out;
        this.generateCode();
        if (this.imageType == ImageEnum.JPG.getType()) {
            this.mimeType = "image/jpg";
            out = new ByteArrayOutputStream();
            ImgUtil.writeJpg((Image)this.createImage(this.codeChar), (OutputStream)out);
            this.imageBytes = out.toByteArray();
        }
        if (this.imageType == ImageEnum.PNG.getType()) {
            this.mimeType = "image/png";
            out = new ByteArrayOutputStream();
            ImgUtil.writePng((Image)this.createImage(this.codeChar), (OutputStream)out);
            this.imageBytes = out.toByteArray();
        }
        if (this.imageType == ImageEnum.GIF.getType()) {
            this.mimeType = "image/gif";
            this.createImageGif(this.codeChar);
        }
    }

    @Override
    public String getText() {
        if (null == this.code) {
            this.create();
        }
        return this.code;
    }

    @Override
    public boolean verify(String checkedCode) {
        return this.generator.verify(this.getText(), checkedCode);
    }

    @Override
    public void write(OutputStream out) {
        IoUtil.write((OutputStream)out, (boolean)false, (byte[])this.getImageBytes());
    }

    public void write(String path) throws IORuntimeException {
        this.write(FileUtil.touch((String)path));
    }

    public void write(File file) throws IORuntimeException {
        try (BufferedOutputStream out = FileUtil.getOutputStream((File)file);){
            this.write(out);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    protected void generateCode() {
        this.codeChar = this.generator.generator();
        this.code = String.valueOf(this.codeChar);
    }

    protected abstract Image createImage(char[] var1);

    protected abstract void createImageGif(char[] var1);

    public byte[] getImageBytes() {
        if (null == this.imageBytes) {
            this.create();
        }
        return this.imageBytes;
    }

    public BufferedImage getImage() {
        return ImgUtil.read((InputStream)IoUtil.toStream((byte[])this.getImageBytes()));
    }

    public String getImageBase64() {
        return Base64.encode((byte[])this.getImageBytes());
    }

    public String getImageBase64Data() {
        return URLUtil.getDataUriBase64((String)this.mimeType, (String)this.getImageBase64());
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public CaptchaGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(CaptchaGenerator generator) {
        this.generator = generator;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public void setTextAlpha(float textAlpha) {
        this.textAlpha = AlphaComposite.getInstance(3, textAlpha);
    }

    public BufferedImage graphicsImage(Color[] fontColor, char[] strs, int flag, int[][] besselXY) {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.setColor(this.background);
        g2d.fillRect(0, 0, this.width, this.height);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setComposite(AlphaComposite.getInstance(3, 0.1f * (float)RandomUtil.randomInt((int)10)));
        InterferingUtil.drawOval(2, g2d, this.width, this.height);
        g2d.setComposite(AlphaComposite.getInstance(3, 0.7f));
        g2d.setStroke(new BasicStroke(1.2f, 0, 2));
        g2d.setColor(fontColor[0]);
        CubicCurve2D.Double shape = new CubicCurve2D.Double(besselXY[0][0], besselXY[0][1], besselXY[1][0], besselXY[1][1], besselXY[2][0], besselXY[2][1], besselXY[3][0], besselXY[3][1]);
        g2d.draw(shape);
        g2d.setFont(this.font);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int fW = this.width / strs.length;
        int fSp = (fW - (int)fontMetrics.getStringBounds("W", g2d).getWidth()) / 2;
        for (int i = 0; i < strs.length; ++i) {
            AlphaComposite ac3 = AlphaComposite.getInstance(3, this.getAlpha(flag, i, strs.length));
            g2d.setComposite(ac3);
            g2d.setColor(fontColor[i]);
            int fY = this.height - (this.height - (int)fontMetrics.getStringBounds(String.valueOf(strs[i]), g2d).getHeight() >> 1);
            g2d.drawString(String.valueOf(strs[i]), i * fW + fSp + 3, fY - 3);
        }
        g2d.dispose();
        return image;
    }

    public float getAlpha(int i, int j) {
        int num = i + j;
        float r = 1.0f / (float)(this.len - 1);
        float s = (float)this.len * r;
        return num >= this.len ? (float)num * r - s : (float)num * r;
    }

    public float getAlpha(int i, int j, int leng) {
        leng = Math.max(leng, this.len);
        int num = i + j;
        float r = 1.0f / (float)(leng - 1);
        float s = (float)leng * r;
        return num >= leng ? (float)num * r - s : (float)num * r;
    }

    public static int num(int min, int max) {
        return min + RandomUtil.randomInt((int)(max - min));
    }

    public static int num(int num) {
        return RandomUtil.randomInt((int)num);
    }
}

