/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.captcha.enums;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.RandomUtil;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;

public enum FontEnum {
    FONT_1("actionj.ttf"),
    FONT_2("epilog.ttf"),
    FONT_3("fresnel.ttf"),
    FONT_4("headache.ttf"),
    FONT_5("lexo.ttf"),
    FONT_6("prefix.ttf"),
    FONT_7("progbot.ttf"),
    FONT_8("ransom.ttf"),
    FONT_9("robot.ttf"),
    FONT_10("scandal.ttf");

    private final String font;

    public static Font rFont(int font, int style, float size) {
        Font fontRes = null;
        try {
            fontRes = Font.createFont(0, ResourceUtil.getStreamSafe((String)FontEnum.values()[font].font)).deriveFont(style, size);
        }
        catch (FontFormatException | IOException | IndexOutOfBoundsException e) {
            return new Font("Arial", 1, (int)size);
        }
        return fontRes;
    }

    public static Font rFont(int font, float size) {
        return FontEnum.rFont(font, 1, size);
    }

    public static Font rFont(float size) {
        FontEnum[] fontEnums = FontEnum.values();
        int font = RandomUtil.randomInt((int)fontEnums.length);
        return FontEnum.rFont(font, size);
    }

    public static Font rFont() {
        return FontEnum.rFont(32.0f);
    }

    public String getFont() {
        return this.font;
    }

    private FontEnum(String font) {
        this.font = font;
    }
}

