package cn.allbs.captcha.core;

import java.io.OutputStream;

/**
 * 验证码基础类
 *
 * @author ChenQi
 */
public interface ICaptcha {

    /**
     * 创建验证码
     */
    void create();

    /**
     * 获取验证码内容
     *
     * @return 验证码内容
     */
    String getText();

    /**
     * 校验验证码是否一致
     *
     * @param checkedCode 待校验验证码
     * @return true 一致
     */
    boolean verify(String checkedCode);

    /**
     * 输出到指定流中
     *
     * @param out 流
     */
    void write(OutputStream out);
}
