package cn.allbs.captcha.generator;

import cn.allbs.captcha.enums.AlphaEnum;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;

/**
 * 纯数字验证码生成器
 *
 * @author ChenQi
 */
public class NumberCaptchaGenerator extends AbstractCaptchaGenerator {
    public NumberCaptchaGenerator(char[] baseChars, int len) {
        super(baseChars, len);
    }

    public NumberCaptchaGenerator(int len) {
        super(AlphaEnum.NUMBERS.getAlphas(), len);
    }

    @Override
    public char[] generator() {
        char[] codes = new char[this.len];
        for (int i = 0; i < this.len; i++) {
            codes[i] = this.baseChars[RandomUtil.randomInt(this.baseChars.length)];
        }
        return codes;
    }

    @Override
    public boolean verify(String generatorCode, String checkedCode) {
        if (StrUtil.isAllNotBlank(generatorCode, checkedCode)) {
            return StrUtil.equalsIgnoreCase(generatorCode, checkedCode);
        }
        return false;
    }
}
