/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.captcha.captcha;

import cn.allbs.captcha.core.AbstractCaptcha;
import cn.allbs.captcha.core.CaptchaDetails;
import cn.allbs.captcha.enums.ColorEnum;
import cn.allbs.captcha.generator.NumberCharMixtureCaptchaGenerator;
import cn.allbs.captcha.utils.GifEncoder;
import cn.allbs.captcha.utils.InterferingUtil;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.util.ObjectUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;

public class NumberCharMixtureCaptcha
extends AbstractCaptcha {
    public NumberCharMixtureCaptcha(int width, int height, int len) {
        super(width, height, new NumberCharMixtureCaptchaGenerator(len), 15, len);
    }

    public NumberCharMixtureCaptcha(CaptchaDetails captchaDetails) {
        super(captchaDetails, new NumberCharMixtureCaptchaGenerator(captchaDetails.len()));
    }

    @Override
    protected Image createImage(char[] code) {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g2d = ImgUtil.createGraphics((BufferedImage)image, (Color)((Color)ObjectUtil.defaultIfNull((Object)this.background, (Object)Color.WHITE)));
        g2d.setColor(this.background);
        g2d.fillRect(0, 0, this.width, this.height);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        InterferingUtil.drawOval(2, g2d, this.width, this.height);
        g2d.setFont(this.font);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int fW = this.width / this.len;
        int fSp = (fW - (int)fontMetrics.getStringBounds("8", g2d).getWidth()) / 2;
        for (int i = 0; i < code.length; ++i) {
            g2d.setColor(ColorEnum.color());
            int fY = this.height - (this.height - (int)fontMetrics.getStringBounds(String.valueOf(code[i]), g2d).getHeight() >> 1);
            g2d.drawString(String.valueOf(code[i]), i * fW + fSp + 3, fY - 3);
        }
        g2d.dispose();
        return image;
    }

    @Override
    protected void createImageGif(char[] code) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Color[] fontColor = new Color[this.len];
        for (int i = 0; i < this.len; ++i) {
            fontColor[i] = this.color;
        }
        int x1 = 5;
        int y1 = NumberCharMixtureCaptcha.num(5, this.height / 2);
        int x2 = this.width - 5;
        int y2 = NumberCharMixtureCaptcha.num(this.height / 2, this.height - 5);
        int ctrlx = NumberCharMixtureCaptcha.num(this.width / 4, this.width / 4 * 3);
        int ctrly = NumberCharMixtureCaptcha.num(5, this.height - 5);
        if (NumberCharMixtureCaptcha.num(2) == 0) {
            int ty = y1;
            y1 = y2;
            y2 = ty;
        }
        int ctrlx1 = NumberCharMixtureCaptcha.num(this.width / 4, this.width / 4 * 3);
        int ctrly1 = NumberCharMixtureCaptcha.num(5, this.height - 5);
        int[][] besselXY = new int[][]{{x1, y1}, {ctrlx, ctrly}, {ctrlx1, ctrly1}, {x2, y2}};
        GifEncoder gifEncoder = new GifEncoder();
        gifEncoder.setQuality(180);
        gifEncoder.setDelay(100);
        gifEncoder.setRepeat(0);
        gifEncoder.start(out);
        for (int i = 0; i < this.len; ++i) {
            BufferedImage frame = this.graphicsImage(fontColor, code, i, besselXY);
            gifEncoder.addFrame(frame);
            frame.flush();
        }
        gifEncoder.finish();
        this.imageBytes = out.toByteArray();
    }
}

