package cn.allbs.captcha.enums;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * 图片类型
 *
 * @author ChenQi
 */
@Getter
@RequiredArgsConstructor
public enum ImageEnum {

    PNG(1),

    JPG(2),

    GIF(3);

    private final Integer type;

    /**
     * 获取图片类型
     *
     * @param type 类型
     * @return 图片类型
     */
    public static ImageEnum imageType(Integer type) {
        ImageEnum[] imageEnums = ImageEnum.values();
        for (ImageEnum imageEnum : imageEnums) {
            if (type.equals(imageEnum.getType())) {
                return imageEnum;
            }
        }
        return ImageEnum.GIF;
    }
}
