/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.captcha.captcha;

import cn.allbs.captcha.core.AbstractCaptcha;
import cn.allbs.captcha.core.CaptchaDetails;
import cn.allbs.captcha.enums.ColorEnum;
import cn.allbs.captcha.generator.ChineseCaptchaGenerator;
import cn.allbs.captcha.utils.GifEncoder;
import cn.allbs.captcha.utils.InterferingUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.CubicCurve2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;

public class ChineseCaptcha
extends AbstractCaptcha {
    public ChineseCaptcha(int width, int height, int len) {
        super(width, height, new ChineseCaptchaGenerator(len), 15, len);
    }

    public ChineseCaptcha(CaptchaDetails captchaDetails) {
        super(captchaDetails, new ChineseCaptchaGenerator(captchaDetails.len()));
    }

    @Override
    protected Image createImage(char[] code) {
        BufferedImage bi = new BufferedImage(this.width, this.height, 1);
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        g2d.setColor(this.background);
        g2d.fillRect(0, 0, this.width, this.height);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        InterferingUtil.drawOval(3, g2d, this.width, this.height);
        g2d.setStroke(new BasicStroke(1.2f, 0, 2));
        InterferingUtil.drawBesselLine(1, g2d, this.width, this.height);
        g2d.setFont(this.font);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int fW = this.width / code.length - 2;
        int fSp = (fW - (int)fontMetrics.getStringBounds("\u738b", g2d).getWidth()) / 2;
        for (int i = 0; i < code.length; ++i) {
            g2d.setColor(ColorEnum.color());
            int fY = this.height - (this.height - (int)fontMetrics.getStringBounds(String.valueOf(code[i]), g2d).getHeight() >> 1);
            g2d.drawString(String.valueOf(code[i]), i * fW + fSp + 3, fY - 3);
        }
        g2d.dispose();
        return bi;
    }

    @Override
    protected void createImageGif(char[] code) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Color[] fontColor = new Color[this.len];
        for (int i = 0; i < this.len; ++i) {
            fontColor[i] = ColorEnum.color();
        }
        int x1 = 5;
        int y1 = ChineseCaptcha.num(5, this.height / 2);
        int x2 = this.width - 5;
        int y2 = ChineseCaptcha.num(this.height / 2, this.height - 5);
        int ctrlx = ChineseCaptcha.num(this.width / 4, this.width / 4 * 3);
        int ctrly = ChineseCaptcha.num(5, this.height - 5);
        if (ChineseCaptcha.num(2) == 0) {
            int ty = y1;
            y1 = y2;
            y2 = ty;
        }
        int ctrlx1 = ChineseCaptcha.num(this.width / 4, this.width / 4 * 3);
        int ctrly1 = ChineseCaptcha.num(5, this.height - 5);
        int[][] besselXY = new int[][]{{x1, y1}, {ctrlx, ctrly}, {ctrlx1, ctrly1}, {x2, y2}};
        GifEncoder gifEncoder = new GifEncoder();
        gifEncoder.setQuality(180);
        gifEncoder.setDelay(100);
        gifEncoder.setRepeat(0);
        gifEncoder.start(out);
        for (int i = 0; i < this.len; ++i) {
            BufferedImage frame = this.graphicsImage(fontColor, code, i, besselXY);
            gifEncoder.addFrame(frame);
            frame.flush();
        }
        gifEncoder.finish();
        this.imageBytes = out.toByteArray();
    }

    @Override
    public BufferedImage graphicsImage(Color[] fontColor, char[] strs, int flag, int[][] besselXY) {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.setColor(this.background);
        g2d.fillRect(0, 0, this.width, this.height);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setComposite(AlphaComposite.getInstance(3, 0.1f * (float)ChineseCaptcha.num(10)));
        InterferingUtil.drawOval(2, g2d, this.width, this.height);
        g2d.setComposite(AlphaComposite.getInstance(3, 0.7f));
        g2d.setStroke(new BasicStroke(1.2f, 0, 2));
        g2d.setColor(fontColor[0]);
        CubicCurve2D.Double shape = new CubicCurve2D.Double(besselXY[0][0], besselXY[0][1], besselXY[1][0], besselXY[1][1], besselXY[2][0], besselXY[2][1], besselXY[3][0], besselXY[3][1]);
        g2d.draw(shape);
        g2d.setFont(this.font);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int fW = this.width / strs.length;
        int fSp = (fW - (int)fontMetrics.getStringBounds("\u738b", g2d).getWidth()) / 2;
        for (int i = 0; i < strs.length; ++i) {
            AlphaComposite ac3 = AlphaComposite.getInstance(3, this.getAlpha(flag, i));
            g2d.setComposite(ac3);
            g2d.setColor(fontColor[i]);
            int fY = this.height - (this.height - (int)fontMetrics.getStringBounds(String.valueOf(strs[i]), g2d).getHeight() >> 1);
            g2d.drawString(String.valueOf(strs[i]), i * fW + fSp + 3, fY - 3);
        }
        g2d.dispose();
        return image;
    }
}

