/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.captcha.enums;

import cn.allbs.captcha.captcha.CharCaptcha;
import cn.allbs.captcha.captcha.ChineseCaptcha;
import cn.allbs.captcha.captcha.LowerCharCaptcha;
import cn.allbs.captcha.captcha.NumberCaptcha;
import cn.allbs.captcha.captcha.NumberCharMixtureCaptcha;
import cn.allbs.captcha.captcha.NumberCountCaptcha;
import cn.allbs.captcha.captcha.UpperCharCaptcha;
import cn.allbs.captcha.core.AbstractCaptcha;
import cn.allbs.captcha.core.CaptchaDetails;

public enum CaptchaEnum {
    NUMBER_CHAR_MIXTURE(1){

        @Override
        public AbstractCaptcha execute(CaptchaDetails captchaDetails) {
            return new NumberCharMixtureCaptcha(captchaDetails);
        }
    }
    ,
    ONLY_NUMBER(2){

        @Override
        public AbstractCaptcha execute(CaptchaDetails captchaDetails) {
            return new NumberCaptcha(captchaDetails);
        }
    }
    ,
    ONLY_CHAR(3){

        @Override
        public AbstractCaptcha execute(CaptchaDetails captchaDetails) {
            return new CharCaptcha(captchaDetails);
        }
    }
    ,
    ONLY_UPPER_CHAR(4){

        @Override
        public AbstractCaptcha execute(CaptchaDetails captchaDetails) {
            return new UpperCharCaptcha(captchaDetails);
        }
    }
    ,
    ONLY_LOWER_CHAR(5){

        @Override
        public AbstractCaptcha execute(CaptchaDetails captchaDetails) {
            return new LowerCharCaptcha(captchaDetails);
        }
    }
    ,
    CHINESE_ONLY(6){

        @Override
        public AbstractCaptcha execute(CaptchaDetails captchaDetails) {
            return new ChineseCaptcha(captchaDetails);
        }
    }
    ,
    NUMBER_COUNT(7){

        @Override
        public AbstractCaptcha execute(CaptchaDetails captchaDetails) {
            return new NumberCountCaptcha(captchaDetails);
        }
    };

    private final Integer type;

    public abstract AbstractCaptcha execute(CaptchaDetails var1);

    public static AbstractCaptcha captchaType(CaptchaDetails captchaDetails) {
        CaptchaEnum[] captchaEnums;
        for (CaptchaEnum captchaEnum : captchaEnums = CaptchaEnum.values()) {
            if (captchaDetails.type() != captchaEnum.getType().intValue()) continue;
            return captchaEnum.execute(captchaDetails);
        }
        return NUMBER_CHAR_MIXTURE.execute(captchaDetails);
    }

    public Integer getType() {
        return this.type;
    }

    private CaptchaEnum(Integer type) {
        this.type = type;
    }
}

