/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.config;

import cn.allbs.hj212.config.SegmentToken;
import cn.allbs.hj212.core.Configurator;
import cn.allbs.hj212.core.Configured;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.stream.Collectors;

public class SegmentGenerator
implements Closeable,
Configured<SegmentGenerator> {
    protected Writer writer;
    private int generatorFeature;
    private SegmentToken nextToken;
    private LinkedList<String> previousKeys = new LinkedList();

    public SegmentGenerator(Writer writer) {
        this.writer = writer;
    }

    public void writeKey(String key) throws IOException {
        this.writePathKey(false, key);
    }

    public void writePathKey(String key) throws IOException {
        this.writePathKey(true, key);
    }

    private void writePathKey(boolean supportSubKey, String key) throws IOException {
        switch (this.nextToken) {
            case END_KEY: 
            case END_PART_KEY: {
                this.writer.write(SegmentToken.END_PART_KEY.start());
                break;
            }
            case END_OBJECT_VALUE: 
            case START_OBJECT_VALUE: {
                throw new IOException("Cant write key after " + this.nextToken.name() + " token!");
            }
            case END_SUB_ENTRY: {
                if (supportSubKey) {
                    this.writer.write(SegmentToken.END_SUB_ENTRY.start());
                    this.writer.write(this.previousKeys.subList(0, this.previousKeys.size() - 1).stream().collect(Collectors.joining("-")));
                    this.writer.write(SegmentToken.END_PART_KEY.start());
                    break;
                }
            }
            case END_ENTRY: {
                this.writer.write(SegmentToken.END_ENTRY.start());
                this.previousKeys.clear();
            }
        }
        this.writer.write(key);
        this.previousKeys.add(key);
        this.nextToken = supportSubKey ? SegmentToken.END_PART_KEY : SegmentToken.END_KEY;
    }

    public void writeValue(String value) throws IOException {
        this.writeValue(false, value);
    }

    public void writeObjectValue(String value) throws IOException {
        this.writeValue(true, value);
    }

    private void writeValue(boolean flagObject, String value) throws IOException {
        switch (this.nextToken) {
            case END_OBJECT_VALUE: 
            case END_SUB_ENTRY: 
            case END_ENTRY: {
                throw new IOException("Cant write value after " + this.nextToken.name() + " token!");
            }
            case END_KEY: 
            case END_PART_KEY: {
                this.writer.write(SegmentToken.END_KEY.start());
            }
        }
        if (value != null) {
            if (flagObject) {
                this.writer.write(SegmentToken.START_OBJECT_VALUE.start());
                this.writer.write(SegmentToken.START_OBJECT_VALUE.start());
                this.writer.write(value);
                this.writer.write(SegmentToken.END_OBJECT_VALUE.start());
                this.writer.write(SegmentToken.END_OBJECT_VALUE.start());
            } else {
                this.writer.write(value);
            }
        }
        this.nextToken = this.previousKeys.isEmpty() || this.previousKeys.size() == 1 ? SegmentToken.END_ENTRY : SegmentToken.END_SUB_ENTRY;
    }

    public SegmentGenerator writeObjectStart() throws IOException {
        switch (this.nextToken) {
            case END_OBJECT_VALUE: 
            case END_SUB_ENTRY: 
            case END_ENTRY: {
                throw new IOException("Cant write value after " + this.nextToken.name() + " token!");
            }
            case END_KEY: 
            case END_PART_KEY: {
                this.writer.write(SegmentToken.END_KEY.start());
            }
        }
        this.writer.write(SegmentToken.START_OBJECT_VALUE.start());
        this.writer.write(SegmentToken.START_OBJECT_VALUE.start());
        this.nextToken = SegmentToken.END_OBJECT_VALUE;
        SegmentGenerator generator = new SegmentGenerator(this.writer);
        generator.initToken();
        return generator;
    }

    public void writeObjectEnd() throws IOException {
        this.writer.write(SegmentToken.END_OBJECT_VALUE.start());
        this.writer.write(SegmentToken.END_OBJECT_VALUE.start());
        this.nextToken = this.previousKeys.isEmpty() ? SegmentToken.END_ENTRY : SegmentToken.END_SUB_ENTRY;
    }

    public SegmentToken nextToken() {
        return this.nextToken;
    }

    public void initToken() {
        this.nextToken = SegmentToken.NOT_AVAILABLE;
    }

    public void setGeneratorFeature(int generatorFeature) {
        this.generatorFeature = generatorFeature;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void configured(Configurator<SegmentGenerator> by) {
        by.config(this);
    }
}

