/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.core;

import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;

public class MapEntryStepGenerator<K, V> {
    private BiConsumer<K, V> consumer;
    private BinaryOperator<K> keyMergeOperator;
    private BinaryOperator<V> valueMergeOperator;
    private Token token;
    private K k;
    private V v;
    private Supplier<K> kSupplier;
    private Supplier<V> vSupplier;

    private MapEntryStepGenerator(BiConsumer<K, V> consumer, BinaryOperator<K> keyMergeOperator, BinaryOperator<V> valueMergeOperator) {
        this.consumer = consumer;
        this.keyMergeOperator = keyMergeOperator;
        this.valueMergeOperator = valueMergeOperator;
        this.token = Token.NONE;
    }

    public void putKey(K k) {
        switch (this.token) {
            case KEY: {
                this.k = this.keyMergeOperator.apply(this.k, k);
                break;
            }
            case VALUE: {
                this.generate();
            }
            case NONE: {
                this.k = k;
                this.token = Token.KEY;
            }
        }
    }

    public void putValue(V v) {
        switch (this.token) {
            case VALUE: {
                this.v = this.valueMergeOperator.apply(this.v, v);
                break;
            }
            case KEY: 
            case NONE: {
                this.v = v;
                this.token = Token.VALUE;
            }
        }
    }

    public void generate() {
        this.consumer.accept(this.k, this.v);
        this.k = this.kSupplier == null ? null : this.kSupplier.get();
        this.v = this.vSupplier == null ? null : this.vSupplier.get();
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static class Builder<K, V> {
        MapEntryStepGenerator<K, V> result = new MapEntryStepGenerator(null, null, null);

        public Builder<K, V> consumer(BiConsumer<K, V> consumer) {
            ((MapEntryStepGenerator)this.result).consumer = consumer;
            return this;
        }

        public Builder<K, V> keyMergeOperator(BinaryOperator<K> keyMergeOperator) {
            ((MapEntryStepGenerator)this.result).keyMergeOperator = keyMergeOperator;
            return this;
        }

        public Builder<K, V> valueMergeOperator(BinaryOperator<V> valueMergeOperator) {
            ((MapEntryStepGenerator)this.result).valueMergeOperator = valueMergeOperator;
            return this;
        }

        public Builder<K, V> keyDefault(Supplier<K> keySupplier) {
            ((MapEntryStepGenerator)this.result).kSupplier = keySupplier;
            return this;
        }

        public Builder<K, V> valueDefault(Supplier<V> valueSupplier) {
            ((MapEntryStepGenerator)this.result).vSupplier = valueSupplier;
            return this;
        }

        public MapEntryStepGenerator<K, V> create() {
            if (((MapEntryStepGenerator)this.result).consumer == null) {
                throw new IllegalArgumentException("consumer");
            }
            if (((MapEntryStepGenerator)this.result).keyMergeOperator == null) {
                throw new IllegalArgumentException("keyMergeOperator");
            }
            if (((MapEntryStepGenerator)this.result).valueMergeOperator == null) {
                throw new IllegalArgumentException("valueMergeOperator");
            }
            return this.result;
        }
    }

    static enum Token {
        NONE,
        KEY,
        VALUE;

    }
}

