/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.core;

import cn.allbs.hj212.core.MapEntryStepGenerator;
import cn.allbs.hj212.core.ReaderMatch;
import cn.allbs.hj212.core.ReaderStream;
import cn.allbs.hj212.lambda.RunnableWithThrowable;
import cn.allbs.hj212.lambda.SupplierWithThrowable;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class MultipleCharMatch<ParentStream extends ReaderStream>
implements ReaderMatch<MultipleCharMatch<ParentStream>, ParentStream, char[]> {
    private ParentStream parentStream;
    private PushbackReader reader;
    private int count;
    private boolean alwaysRollBack = false;
    private Map<Predicate<char[]>, SupplierWithThrowable<Optional<Object>, IOException>> map;
    private MapEntryStepGenerator<Predicate<char[]>, SupplierWithThrowable<Optional<Object>, IOException>> generator;

    public MultipleCharMatch(ParentStream parentStream, int count) {
        this.parentStream = parentStream;
        this.reader = ((ReaderStream)parentStream).reader();
        this.count = count;
        this.map = new LinkedHashMap<Predicate<char[]>, SupplierWithThrowable<Optional<Object>, IOException>>();
        MapEntryStepGenerator.Builder<Predicate, SupplierWithThrowable> builder = MapEntryStepGenerator.builder();
        this.generator = builder.consumer((k, v) -> this.map.put((Predicate<char[]>)k, (SupplierWithThrowable<Optional<Object>, IOException>)v)).keyDefault(() -> character -> false).keyMergeOperator(Predicate::or).valueMergeOperator((thisRunnable, runnable) -> () -> {
            Optional o = (Optional)thisRunnable.get();
            if (!o.isPresent()) {
                o = (Optional)runnable.get();
            }
            return o;
        }).create();
    }

    public MultipleCharMatch<ParentStream> when(Predicate<char[]> predicate) {
        this.generator.putKey(predicate);
        return this;
    }

    public MultipleCharMatch<ParentStream> when(char ... characters) {
        this.generator.putKey(ca -> Arrays.equals(ca, characters));
        return this;
    }

    public MultipleCharMatch<ParentStream> then(Supplier<IOException> exceptionSupplier) {
        this.generator.putValue(() -> {
            throw (IOException)exceptionSupplier.get();
        });
        return this;
    }

    public MultipleCharMatch<ParentStream> then(SupplierWithThrowable<Optional<Object>, IOException> runnable) {
        this.generator.putValue(runnable);
        return this;
    }

    public MultipleCharMatch<ParentStream> then(RunnableWithThrowable<IOException> runnable) {
        this.generator.putValue(() -> {
            runnable.run();
            return Optional.of(true);
        });
        return this;
    }

    public ReaderStream<MultipleCharMatch<ParentStream>> then() {
        ReaderStream<MultipleCharMatch<ParentStream>> reader = new ReaderStream<MultipleCharMatch<ParentStream>>(this.reader, ((ReaderStream)this.parentStream).bufSize() - 1, this);
        this.then(reader::match);
        return reader;
    }

    @Override
    public ParentStream done() {
        this.generator.generate();
        return this.parentStream;
    }

    public ParentStream stop() {
        return this.done();
    }

    public ParentStream back() {
        this.alwaysRollBack = true;
        return this.done();
    }

    @Override
    public Optional<char[]> match() throws IOException {
        char[] chars = new char[this.count];
        this.reader.read(chars);
        Optional<SupplierWithThrowable> r = this.map.entrySet().stream().filter(kv -> ((Predicate)kv.getKey()).test(chars)).map(Map.Entry::getValue).findAny();
        if (r.isPresent() && ((Optional)r.get().get()).isPresent() && !this.alwaysRollBack) {
            return Optional.of(chars);
        }
        this.reader.unread(chars);
        return Optional.empty();
    }

    public String toString() {
        return ((ReaderStream)this.parentStream).toString() + "/" + this.getClass().getSimpleName() + "(" + this.map.size() + ")";
    }
}

