/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.influx;

import cn.allbs.influx.InfluxDbProperties;
import cn.hutool.core.bean.BeanUtil;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.influxdb.BatchOptions;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxTemplate {
    private static final Logger log = LoggerFactory.getLogger(InfluxTemplate.class);
    private final String database;
    private final String retentionPolicy;
    private final String retentionPolicyTime;
    private InfluxDB influxdb;
    private final BatchOptions batchOptions;

    public InfluxTemplate(InfluxDbProperties influxDbProperties, BatchOptions batchOptions) {
        this.batchOptions = batchOptions == null ? BatchOptions.DEFAULTS : batchOptions;
        this.database = influxDbProperties.getDatabase();
        influxDbProperties.setRetentionPolicy(Optional.of(influxDbProperties).map(InfluxDbProperties::getRetentionPolicy).orElse("autogen"));
        influxDbProperties.setRetentionPolicyTime(Optional.of(influxDbProperties).map(InfluxDbProperties::getRetentionPolicyTime).orElse("0"));
        this.retentionPolicy = influxDbProperties.getRetentionPolicy();
        this.retentionPolicyTime = influxDbProperties.getRetentionPolicyTime();
        this.influxdb = this.buildInfluxDb(influxDbProperties);
    }

    public InfluxDB buildInfluxDb(InfluxDbProperties influxDbProperties) {
        if (this.influxdb == null) {
            this.influxdb = InfluxDBFactory.connect((String)influxDbProperties.getOpenUrl(), (String)influxDbProperties.getUsername(), (String)influxDbProperties.getPassword());
            try {
                this.createDatabase(this.database);
            }
            catch (Exception e) {
                log.info("create database error " + e.getMessage());
            }
            this.influxdb.setDatabase(this.database);
        }
        log.debug("init influxDb, current configuration is " + BeanUtil.beanToMap((Object)influxDbProperties, (String[])new String[0]));
        return this.influxdb;
    }

    public void createRetentionPolicy() {
        String command = String.format("CREATE RETENTION POLICY \"%s\" ON \"%s\" DURATION %s REPLICATION %s DEFAULT", this.retentionPolicy, this.database, this.retentionPolicyTime, 1);
        this.query(command);
    }

    public void createRetentionPolicy(String policyName, String duration, int replication, boolean isDefault) {
        String command = String.format("CREATE RETENTION POLICY \"%s\" ON \"%s\" DURATION %s REPLICATION %s ", policyName, this.database, duration, replication);
        if (isDefault) {
            command = command + " DEFAULT";
        }
        this.query(command);
    }

    public void createDatabase(String database) {
        this.influxdb.query(new Query("CREATE DATABASE " + database));
    }

    public QueryResult query(String command) {
        return this.influxdb.query(new Query(command, this.database));
    }

    public void insert(String measurement, Map<String, String> tags, Map<String, Object> fields) {
        this.insert(measurement, tags, fields, 0L, null);
    }

    public void insert(String measurement, Map<String, String> tags, Map<String, Object> fields, long time, TimeUnit timeUnit) {
        if (time == 0L) {
            time = Instant.now().toEpochMilli();
            timeUnit = TimeUnit.MILLISECONDS;
        }
        Point point = Point.measurement((String)measurement).time(time, timeUnit).tag(tags).fields(fields).build();
        log.info("influxDB insert data:" + point.toString());
        this.influxdb.write(this.database, this.retentionPolicy, point);
    }

    public void batchInsert(String measurement, Map<String, String> tags, List<Map<String, Object>> fieldLists) {
        this.batchInsert(measurement, tags, fieldLists, 0L, null);
    }

    public void batchInsert(String measurement, Map<String, String> tags, List<Map<String, Object>> fieldLists, long time, TimeUnit timeUnit) {
        if (time == 0L) {
            time = Instant.now().toEpochMilli();
            timeUnit = TimeUnit.MILLISECONDS;
        }
        BatchPoints batchPoints = BatchPoints.database((String)this.database).retentionPolicy(this.retentionPolicy).consistency(InfluxDB.ConsistencyLevel.ALL).build();
        fieldLists.stream().forEach(a -> {
            Point point = Point.measurement((String)measurement).tag(tags).fields(a).build();
            batchPoints.point(point);
        });
        log.info("influxDB insert batch data:" + batchPoints.toString());
        this.influxdb.write(batchPoints);
    }

    public void batchInsert(BatchPoints batchPoints) {
        this.influxdb.write(batchPoints);
    }

    public void flush() {
        if (this.influxdb != null) {
            this.influxdb.flush();
        }
    }

    public void enableBatch() {
        if (this.influxdb != null) {
            this.influxdb.enableBatch(this.batchOptions);
        }
    }

    public void disableBatch() {
        if (this.influxdb != null) {
            this.influxdb.disableBatch();
        }
    }

    public boolean ping() {
        boolean isConnected = false;
        try {
            Pong pong = this.influxdb.ping();
            if (pong != null) {
                isConnected = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isConnected;
    }
}

