/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.influx;

import cn.allbs.influx.InfluxDbProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.influxdb.BatchOptions;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxTemplate {
    private static final Logger log = LoggerFactory.getLogger(InfluxTemplate.class);
    private final String database;
    private final String retentionPolicy;
    private final String retentionPolicyTime;
    private InfluxDB influxdb;
    private final BatchOptions batchOptions;
    @Resource
    private ObjectMapper mapper;

    public InfluxTemplate(InfluxDbProperties influxDbProperties, BatchOptions batchOptions) {
        this.batchOptions = batchOptions == null ? BatchOptions.DEFAULTS : batchOptions;
        this.database = influxDbProperties.getDatabase();
        influxDbProperties.setRetentionPolicy(Optional.of(influxDbProperties).map(InfluxDbProperties::getRetentionPolicy).orElse("autogen"));
        influxDbProperties.setRetentionPolicyTime(Optional.of(influxDbProperties).map(InfluxDbProperties::getRetentionPolicyTime).orElse("0"));
        this.retentionPolicy = influxDbProperties.getRetentionPolicy();
        this.retentionPolicyTime = influxDbProperties.getRetentionPolicyTime();
        this.influxdb = this.buildInfluxDb(influxDbProperties);
    }

    public InfluxDB buildInfluxDb(InfluxDbProperties influxDbProperties) {
        if (this.influxdb == null) {
            this.influxdb = InfluxDBFactory.connect((String)influxDbProperties.getOpenUrl(), (String)influxDbProperties.getUsername(), (String)influxDbProperties.getPassword());
            try {
                this.createDatabase(this.database);
            }
            catch (Exception e) {
                log.info("create database error " + e.getMessage());
            }
            this.influxdb.setDatabase(this.database);
        }
        log.debug("init influxDb, current configuration is " + influxDbProperties);
        return this.influxdb;
    }

    public void createRetentionPolicy() {
        String command = String.format("CREATE RETENTION POLICY \"%s\" ON \"%s\" DURATION %s REPLICATION %s DEFAULT", this.retentionPolicy, this.database, this.retentionPolicyTime, 1);
        this.query(command);
    }

    public void createRetentionPolicy(String policyName, String duration, int replication, boolean isDefault) {
        String command = String.format("CREATE RETENTION POLICY \"%s\" ON \"%s\" DURATION %s REPLICATION %s ", policyName, this.database, duration, replication);
        if (isDefault) {
            command = command + " DEFAULT";
        }
        this.query(command);
    }

    public void createDatabase(String database) {
        this.influxdb.query(new Query("CREATE DATABASE " + database));
    }

    public QueryResult query(String command) {
        return this.influxdb.query(new Query(command, this.database));
    }

    public List<Map<String, Object>> queryMapList(String command) {
        return this.queryMapList(command, "yyyy-MM-dd HH:mm:ss");
    }

    public List<Map<String, Object>> queryMapList(String command, String dateTimeFormatter) {
        QueryResult.Series series;
        LinkedList<Map<String, Object>> resList = new LinkedList<Map<String, Object>>();
        QueryResult queryResult = this.query(command);
        QueryResult.Result result = (QueryResult.Result)queryResult.getResults().get(0);
        if (Optional.of(result).map(QueryResult.Result::getSeries).isPresent() && Optional.of(series = (QueryResult.Series)result.getSeries().get(0)).map(QueryResult.Series::getColumns).isPresent() && Optional.of(series).map(QueryResult.Series::getValues).isPresent()) {
            List columns = series.getColumns();
            series.getValues().forEach(v -> {
                HashMap dataMap = new HashMap();
                for (int i = 0; i < columns.size(); ++i) {
                    String key = (String)columns.get(i);
                    Object value = v.get(i);
                    if ("time".equals(key)) {
                        value = LocalDateTime.parse(value.toString(), DateTimeFormatter.ISO_DATE_TIME).format(DateTimeFormatter.ofPattern(dateTimeFormatter));
                    }
                    dataMap.put(key, value);
                }
                resList.add(dataMap);
            });
        }
        return resList;
    }

    public <T> List<T> queryBeanList(String command, Class<T> targetType) {
        QueryResult.Series series;
        List<Object> resList = new LinkedList();
        QueryResult queryResult = this.query(command);
        QueryResult.Result result = (QueryResult.Result)queryResult.getResults().get(0);
        if (Optional.of(result).map(QueryResult.Result::getSeries).isPresent() && Optional.of(series = (QueryResult.Series)result.getSeries().get(0)).map(QueryResult.Series::getColumns).isPresent() && Optional.of(series).map(QueryResult.Series::getValues).isPresent()) {
            List columns = series.getColumns();
            resList = series.getValues().stream().map(v -> {
                HashMap dataMap = new HashMap();
                for (int i = 0; i < columns.size(); ++i) {
                    String key = (String)columns.get(i);
                    Object value = v.get(i);
                    dataMap.put(key, value);
                }
                try {
                    return this.mapper.readValue(this.mapper.writeValueAsString(dataMap), targetType);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        return resList;
    }

    public void insert(String measurement, Map<String, String> tags, Map<String, Object> fields) {
        this.insert(measurement, tags, fields, 0L, null, ZoneOffset.UTC);
    }

    public void insert(String measurement, Map<String, String> tags, Map<String, Object> fields, ZoneOffset zoneOffset) {
        this.insert(measurement, tags, fields, 0L, null, zoneOffset);
    }

    public void insert(String measurement, Map<String, String> tags, Map<String, Object> fields, long time, TimeUnit timeUnit, ZoneOffset zoneOffset) {
        if (time == 0L) {
            time = LocalDateTime.now().toInstant(zoneOffset).toEpochMilli();
            timeUnit = TimeUnit.MILLISECONDS;
        }
        Point point = Point.measurement((String)measurement).time(time, timeUnit).tag(tags).fields(fields).build();
        log.info("influxDB insert data:" + point);
        this.influxdb.write(this.database, this.retentionPolicy, point);
    }

    public void batchInsert(String measurement, Map<String, String> tags, List<Map<String, Object>> fieldLists, ZoneOffset zoneOffset) {
        BatchPoints batchPoints = BatchPoints.database((String)this.database).retentionPolicy(this.retentionPolicy).consistency(InfluxDB.ConsistencyLevel.ALL).build();
        for (int i = 0; i < fieldLists.size(); ++i) {
            Point point = Point.measurement((String)measurement).time(LocalDateTime.now().toInstant(zoneOffset).toEpochMilli() * 1000L + (long)i, TimeUnit.MICROSECONDS).tag(tags).fields(fieldLists.get(i)).build();
            batchPoints.point(point);
        }
        log.info("influxDB insert batch data:" + batchPoints);
        this.influxdb.write(batchPoints);
    }

    public void batchInsert(String measurement, Map<String, String> tags, List<Map<String, Object>> fieldLists) {
        this.batchInsert(measurement, tags, fieldLists, ZoneOffset.UTC);
    }

    public void batchInsert(BatchPoints batchPoints) {
        this.influxdb.write(batchPoints);
    }

    public void flush() {
        if (this.influxdb != null) {
            this.influxdb.flush();
        }
    }

    public void enableBatch() {
        if (this.influxdb != null) {
            this.influxdb.enableBatch(this.batchOptions);
        }
    }

    public void disableBatch() {
        if (this.influxdb != null) {
            this.influxdb.disableBatch();
        }
    }

    public boolean ping() {
        boolean isConnected = false;
        try {
            Pong pong = this.influxdb.ping();
            if (pong != null) {
                isConnected = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isConnected;
    }
}

