/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.influx;

import cn.allbs.influx.InfluxDbProperties;
import cn.allbs.influx.InfluxTemplate;
import cn.allbs.influx.exception.InfluxdbException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.influxdb.BatchOptions;
import org.influxdb.InfluxDB;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InfluxDbClient
implements InfluxTemplate {
    private static final Logger log = LoggerFactory.getLogger(InfluxDbClient.class);
    protected String database;
    protected String retentionPolicy;
    protected String retentionPolicyTime;
    protected InfluxDB influxdb;
    protected BatchOptions batchOptions;
    protected InfluxDbProperties influxDbProperties;
    @Resource
    private ObjectMapper mapper;

    public InfluxDbClient(InfluxDbProperties influxDbProperties, BatchOptions batchOptions) {
        this.batchOptions = batchOptions == null ? BatchOptions.DEFAULTS : batchOptions;
        this.database = influxDbProperties.getDatabase();
        this.retentionPolicy = influxDbProperties.getRetentionPolicy();
        this.retentionPolicyTime = influxDbProperties.getRetentionPolicyTime();
        influxDbProperties.setRetentionPolicy(Optional.of(influxDbProperties).map(InfluxDbProperties::getRetentionPolicy).orElse("autogen"));
        influxDbProperties.setRetentionPolicyTime(Optional.of(influxDbProperties).map(InfluxDbProperties::getRetentionPolicyTime).orElse("0"));
        this.influxDbProperties = influxDbProperties;
    }

    @Override
    public InfluxDB buildInfluxDb() {
        return this.influxdb;
    }

    @Override
    public void createRetentionPolicy() {
        String command = String.format("CREATE RETENTION POLICY \"%s\" ON \"%s\" DURATION %s REPLICATION %s DEFAULT", this.retentionPolicy, this.database, this.retentionPolicyTime, 1);
        this.query(command);
    }

    @Override
    public void createRetentionPolicy(String policyName, String duration, int replication, boolean isDefault) {
        String command = String.format("CREATE RETENTION POLICY \"%s\" ON \"%s\" DURATION %s REPLICATION %s ", policyName, this.database, duration, replication);
        if (isDefault) {
            command = command + " DEFAULT";
        }
        this.query(command);
    }

    @Override
    public void createDatabase(String database) {
        this.influxdb.query(new Query("CREATE DATABASE " + database));
    }

    @Override
    public QueryResult query(String command) {
        QueryResult queryResult;
        this.reConnect();
        try {
            queryResult = this.influxdb.query(new Query(command, this.database));
        }
        catch (Exception e) {
            log.error("influxdb\u64cd\u4f5c\u5931\u8d25:{}", (Object)e.getLocalizedMessage());
            throw new InfluxdbException("influxdb\u64cd\u4f5c\u5931\u8d25:" + e.getLocalizedMessage());
        }
        return queryResult;
    }

    @Override
    public List<Map<String, Object>> queryMapList(String command) {
        return this.queryMapList(command, "yyyy-MM-dd HH:mm:ss");
    }

    @Override
    public List<Map<String, Object>> queryMapList(String command, String dateTimeFormatter) {
        QueryResult.Series series;
        LinkedList<Map<String, Object>> resList = new LinkedList<Map<String, Object>>();
        QueryResult queryResult = this.query(command);
        QueryResult.Result result = (QueryResult.Result)queryResult.getResults().get(0);
        if (Optional.of(result).map(QueryResult.Result::getSeries).isPresent() && Optional.of(series = (QueryResult.Series)result.getSeries().get(0)).map(QueryResult.Series::getColumns).isPresent() && Optional.of(series).map(QueryResult.Series::getValues).isPresent()) {
            List columns = series.getColumns();
            series.getValues().forEach(v -> {
                HashMap dataMap = new HashMap();
                for (int i = 0; i < columns.size(); ++i) {
                    String key = (String)columns.get(i);
                    Object value = v.get(i);
                    if ("time".equals(key)) {
                        value = LocalDateTime.parse(value.toString(), DateTimeFormatter.ISO_DATE_TIME).format(DateTimeFormatter.ofPattern(dateTimeFormatter));
                    }
                    dataMap.put(key, value);
                }
                resList.add(dataMap);
            });
        }
        return resList;
    }

    @Override
    public <T> List<T> queryBeanList(String command, Class<T> targetType) {
        QueryResult.Series series;
        List<Object> resList = new LinkedList();
        QueryResult queryResult = this.query(command);
        QueryResult.Result result = (QueryResult.Result)queryResult.getResults().get(0);
        if (Optional.of(result).map(QueryResult.Result::getSeries).isPresent() && Optional.of(series = (QueryResult.Series)result.getSeries().get(0)).map(QueryResult.Series::getColumns).isPresent() && Optional.of(series).map(QueryResult.Series::getValues).isPresent()) {
            List columns = series.getColumns();
            resList = series.getValues().stream().map(v -> {
                HashMap dataMap = new HashMap();
                for (int i = 0; i < columns.size(); ++i) {
                    String key = (String)columns.get(i);
                    Object value = v.get(i);
                    dataMap.put(key, value);
                }
                try {
                    return this.mapper.readValue(this.mapper.writeValueAsString(dataMap), targetType);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        return resList;
    }

    @Override
    public void insert(String measurement, Map<String, String> tags, Map<String, Object> fields) {
        this.insert(measurement, tags, fields, 0L, null, ZoneOffset.UTC);
    }

    @Override
    public void insert(String measurement, Map<String, String> tags, Map<String, Object> fields, ZoneOffset zoneOffset) {
        this.insert(measurement, tags, fields, 0L, null, zoneOffset);
    }

    @Override
    public void insert(String measurement, Map<String, String> tags, Map<String, Object> fields, long time, TimeUnit timeUnit, ZoneOffset zoneOffset) {
        this.reConnect();
        if (time == 0L) {
            time = LocalDateTime.now().toInstant(zoneOffset).toEpochMilli();
            timeUnit = TimeUnit.MILLISECONDS;
        }
        Point point = Point.measurement((String)measurement).time(time, timeUnit).tag(tags).fields(fields).build();
        log.info("influxDB insert data:" + point);
        try {
            this.influxdb.write(this.database, this.retentionPolicy, point);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u63d2\u5165\u5931\u8d25:{}", (Object)e.getLocalizedMessage());
            throw new InfluxdbException("\u6570\u636e\u63d2\u5165\u5931\u8d25:" + e.getLocalizedMessage());
        }
    }

    @Override
    public void batchInsert(String measurement, Map<String, String> tags, List<Map<String, Object>> fieldLists, ZoneOffset zoneOffset) {
        this.reConnect();
        BatchPoints batchPoints = BatchPoints.database((String)this.database).retentionPolicy(this.retentionPolicy).consistency(InfluxDB.ConsistencyLevel.ALL).build();
        for (int i = 0; i < fieldLists.size(); ++i) {
            Point point = Point.measurement((String)measurement).time(LocalDateTime.now().toInstant(zoneOffset).toEpochMilli() * 1000L + (long)i, TimeUnit.MICROSECONDS).tag(tags).fields(fieldLists.get(i)).build();
            batchPoints.point(point);
        }
        log.info("influxDB insert batch data:" + batchPoints);
        try {
            this.influxdb.write(batchPoints);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u6279\u91cf\u63d2\u5165\u5931\u8d25:{}", (Object)e.getLocalizedMessage());
            throw new InfluxdbException("\u6570\u636e\u6279\u91cf\u63d2\u5165\u5931\u8d25:" + e.getLocalizedMessage());
        }
    }

    @Override
    public void batchInsert(String measurement, Map<String, String> tags, List<Map<String, Object>> fieldLists) {
        this.batchInsert(measurement, tags, fieldLists, ZoneOffset.UTC);
    }

    @Override
    public void batchInsert(BatchPoints batchPoints) {
        this.reConnect();
        try {
            this.influxdb.write(batchPoints);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u6279\u91cf\u63d2\u5165\u5931\u8d25:{}", (Object)e.getLocalizedMessage());
            throw new InfluxdbException("\u6570\u636e\u6279\u91cf\u63d2\u5165\u5931\u8d25:" + e.getLocalizedMessage());
        }
    }

    @Override
    public void flush() {
        if (this.influxdb != null) {
            this.influxdb.flush();
        }
    }

    @Override
    public void enableBatch() {
        if (this.influxdb != null) {
            this.influxdb.enableBatch(this.batchOptions);
        }
    }

    @Override
    public void disableBatch() {
        if (this.influxdb != null) {
            this.influxdb.disableBatch();
        }
    }

    @Override
    public boolean ping() {
        boolean isConnected = false;
        try {
            Pong pong = this.influxdb.ping();
            if (pong != null) {
                isConnected = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isConnected;
    }

    @Override
    public void reConnect() {
        if (this.influxdb == null) {
            this.influxdb = this.buildInfluxDb();
        }
    }
}

