/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.influx;

import cn.allbs.influx.InfluxDbProperties;
import cn.allbs.influx.InfluxTemplate;
import cn.allbs.influx.client.DefaultInfluxTemplate;
import cn.allbs.influx.client.NullInfluxTemplate;
import cn.allbs.influx.exception.InfluxdbException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.influxdb.BatchOptions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={InfluxDbProperties.class})
public class InfluxDbConfiguration {
    private final InfluxDbProperties influxDbProperties;

    public InfluxDbConfiguration(InfluxDbProperties influxDbProperties) {
        this.influxDbProperties = influxDbProperties;
    }

    @Bean
    @ConditionalOnClass(value={ObjectMapper.class})
    @ConditionalOnMissingBean(value={InfluxTemplate.class})
    public InfluxTemplate influxTemplate() {
        BatchOptions batchOptions = BatchOptions.DEFAULTS;
        try {
            DefaultInfluxTemplate influxDbClient = new DefaultInfluxTemplate(this.influxDbProperties, batchOptions);
            influxDbClient.createRetentionPolicy();
            return influxDbClient;
        }
        catch (Exception e) {
            if (this.influxDbProperties.isSkipError()) {
                return new NullInfluxTemplate(this.influxDbProperties, batchOptions);
            }
            throw new InfluxdbException("Failed to create InfluxDbClient bean", e);
        }
    }
}

