/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.imaging.jpeg;

import cn.allbs.metadata.imaging.jpeg.JpegProcessingException;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentData;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentMetadataReader;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentReader;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentType;
import cn.allbs.metadata.lang.StreamReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.adobe.AdobeJpegReader;
import cn.allbs.metadata.metadata.exif.ExifReader;
import cn.allbs.metadata.metadata.file.FileSystemMetadataReader;
import cn.allbs.metadata.metadata.icc.IccReader;
import cn.allbs.metadata.metadata.iptc.IptcReader;
import cn.allbs.metadata.metadata.jfif.JfifReader;
import cn.allbs.metadata.metadata.jfxx.JfxxReader;
import cn.allbs.metadata.metadata.jpeg.JpegCommentReader;
import cn.allbs.metadata.metadata.jpeg.JpegDhtReader;
import cn.allbs.metadata.metadata.jpeg.JpegDnlReader;
import cn.allbs.metadata.metadata.jpeg.JpegReader;
import cn.allbs.metadata.metadata.photoshop.DuckyReader;
import cn.allbs.metadata.metadata.photoshop.PhotoshopReader;
import cn.allbs.metadata.metadata.xmp.XmpReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;

public class JpegMetadataReader {
    public static final Iterable<JpegSegmentMetadataReader> ALL_READERS = Arrays.asList(new JpegReader(), new JpegCommentReader(), new JfifReader(), new JfxxReader(), new ExifReader(), new XmpReader(), new IccReader(), new PhotoshopReader(), new DuckyReader(), new IptcReader(), new AdobeJpegReader(), new JpegDhtReader(), new JpegDnlReader());

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream, @Nullable Iterable<JpegSegmentMetadataReader> readers) throws JpegProcessingException, IOException {
        Metadata metadata = new Metadata();
        JpegMetadataReader.process(metadata, inputStream, readers);
        return metadata;
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws JpegProcessingException, IOException {
        return JpegMetadataReader.readMetadata(inputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Metadata readMetadata(@NotNull File file, @Nullable Iterable<JpegSegmentMetadataReader> readers) throws JpegProcessingException, IOException {
        Metadata metadata;
        try (FileInputStream inputStream = new FileInputStream(file);){
            metadata = JpegMetadataReader.readMetadata(inputStream, readers);
        }
        new FileSystemMetadataReader().read(file, metadata);
        return metadata;
    }

    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws JpegProcessingException, IOException {
        return JpegMetadataReader.readMetadata(file, null);
    }

    public static void process(@NotNull Metadata metadata, @NotNull InputStream inputStream) throws JpegProcessingException, IOException {
        JpegMetadataReader.process(metadata, inputStream, null);
    }

    public static void process(@NotNull Metadata metadata, @NotNull InputStream inputStream, @Nullable Iterable<JpegSegmentMetadataReader> readers) throws JpegProcessingException, IOException {
        if (readers == null) {
            readers = ALL_READERS;
        }
        HashSet<JpegSegmentType> segmentTypes = new HashSet<JpegSegmentType>();
        for (JpegSegmentMetadataReader reader : readers) {
            for (JpegSegmentType type : reader.getSegmentTypes()) {
                segmentTypes.add(type);
            }
        }
        JpegSegmentData segmentData = JpegSegmentReader.readSegments(new StreamReader(inputStream), segmentTypes);
        JpegMetadataReader.processJpegSegmentData(metadata, readers, segmentData);
    }

    public static void processJpegSegmentData(Metadata metadata, Iterable<JpegSegmentMetadataReader> readers, JpegSegmentData segmentData) {
        for (JpegSegmentMetadataReader reader : readers) {
            for (JpegSegmentType segmentType : reader.getSegmentTypes()) {
                reader.readJpegSegments(segmentData.getSegments(segmentType), metadata, segmentType);
            }
        }
    }

    private JpegMetadataReader() throws Exception {
        throw new Exception("Not intended for instantiation");
    }
}

