/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.imaging.mp3;

import cn.allbs.metadata.imaging.FileType;
import cn.allbs.metadata.imaging.TypeChecker;

public class MpegAudioTypeChecker
implements TypeChecker {
    @Override
    public int getByteCount() {
        return 3;
    }

    @Override
    public FileType checkType(byte[] bytes) {
        if (bytes[0] != -1 || (bytes[1] & 0xE0) != 224) {
            return FileType.Unknown;
        }
        int version = bytes[1] >> 3 & 3;
        if (version == 1) {
            return FileType.Unknown;
        }
        int layerDescription = bytes[1] >> 1 & 3;
        if (layerDescription == 0) {
            return FileType.Unknown;
        }
        int bitrateIndex = bytes[2] >> 4;
        if (bitrateIndex == 15) {
            return FileType.Unknown;
        }
        return FileType.Mp3;
    }
}

