/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.lang;

import cn.allbs.metadata.lang.BufferBoundsException;
import cn.allbs.metadata.lang.RandomAccessReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.SuppressWarnings;
import java.io.IOException;

public class ByteArrayReader
extends RandomAccessReader {
    @NotNull
    private final byte[] _buffer;
    private final int _baseOffset;

    @SuppressWarnings(value="EI_EXPOSE_REP2", justification="Design intent")
    public ByteArrayReader(@NotNull byte[] buffer) {
        this(buffer, 0);
    }

    @SuppressWarnings(value="EI_EXPOSE_REP2", justification="Design intent")
    public ByteArrayReader(@NotNull byte[] buffer, int baseOffset) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (baseOffset < 0) {
            throw new IllegalArgumentException("Must be zero or greater");
        }
        this._buffer = buffer;
        this._baseOffset = baseOffset;
    }

    @Override
    public int toUnshiftedOffset(int localOffset) {
        return localOffset + this._baseOffset;
    }

    @Override
    public long getLength() {
        return this._buffer.length - this._baseOffset;
    }

    @Override
    public byte getByte(int index) throws IOException {
        this.validateIndex(index, 1);
        return this._buffer[index + this._baseOffset];
    }

    @Override
    protected void validateIndex(int index, int bytesRequested) throws IOException {
        if (!this.isValidIndex(index, bytesRequested)) {
            throw new BufferBoundsException(this.toUnshiftedOffset(index), bytesRequested, this._buffer.length);
        }
    }

    @Override
    protected boolean isValidIndex(int index, int bytesRequested) throws IOException {
        return bytesRequested >= 0 && index >= 0 && (long)index + (long)bytesRequested - 1L < this.getLength();
    }

    @Override
    @NotNull
    public byte[] getBytes(int index, int count) throws IOException {
        this.validateIndex(index, count);
        byte[] bytes = new byte[count];
        System.arraycopy(this._buffer, index + this._baseOffset, bytes, 0, count);
        return bytes;
    }
}

