/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.exif;

import cn.allbs.metadata.imaging.jpeg.JpegSegmentMetadataReader;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentType;
import cn.allbs.metadata.imaging.tiff.TiffProcessingException;
import cn.allbs.metadata.imaging.tiff.TiffReader;
import cn.allbs.metadata.lang.ByteArrayReader;
import cn.allbs.metadata.lang.RandomAccessReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.Directory;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.exif.ExifTiffHandler;
import java.io.IOException;
import java.util.Collections;

public class ExifReader
implements JpegSegmentMetadataReader {
    public static final String JPEG_SEGMENT_PREAMBLE = "Exif\u0000\u0000";

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Collections.singletonList(JpegSegmentType.APP1);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> segments, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        assert (segmentType == JpegSegmentType.APP1);
        for (byte[] segmentBytes : segments) {
            if (!ExifReader.startsWithJpegExifPreamble(segmentBytes)) continue;
            this.extract(new ByteArrayReader(segmentBytes), metadata, JPEG_SEGMENT_PREAMBLE.length());
        }
    }

    public static boolean startsWithJpegExifPreamble(byte[] bytes) {
        return bytes.length >= JPEG_SEGMENT_PREAMBLE.length() && new String(bytes, 0, JPEG_SEGMENT_PREAMBLE.length()).equals(JPEG_SEGMENT_PREAMBLE);
    }

    public void extract(@NotNull RandomAccessReader reader, @NotNull Metadata metadata) {
        this.extract(reader, metadata, 0);
    }

    public void extract(@NotNull RandomAccessReader reader, @NotNull Metadata metadata, int readerOffset) {
        this.extract(reader, metadata, readerOffset, null);
    }

    public void extract(@NotNull RandomAccessReader reader, @NotNull Metadata metadata, int readerOffset, @Nullable Directory parentDirectory) {
        ExifTiffHandler exifTiffHandler = new ExifTiffHandler(metadata, parentDirectory);
        try {
            new TiffReader().processTiff(reader, exifTiffHandler, readerOffset);
        }
        catch (TiffProcessingException e) {
            exifTiffHandler.error("Exception processing TIFF data: " + e.getMessage());
        }
        catch (IOException e) {
            exifTiffHandler.error("Exception processing TIFF data: " + e.getMessage());
        }
    }
}

