/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.exif;

import cn.allbs.metadata.lang.Rational;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.TagDescriptor;
import cn.allbs.metadata.metadata.exif.PanasonicRawDistortionDirectory;

public class PanasonicRawDistortionDescriptor
extends TagDescriptor<PanasonicRawDistortionDirectory> {
    public PanasonicRawDistortionDescriptor(@NotNull PanasonicRawDistortionDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 2: {
                return this.getDistortionParam02Description();
            }
            case 4: {
                return this.getDistortionParam04Description();
            }
            case 5: {
                return this.getDistortionScaleDescription();
            }
            case 7: {
                return this.getDistortionCorrectionDescription();
            }
            case 8: {
                return this.getDistortionParam08Description();
            }
            case 9: {
                return this.getDistortionParam09Description();
            }
            case 11: {
                return this.getDistortionParam11Description();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getDistortionParam02Description() {
        Integer value = ((PanasonicRawDistortionDirectory)this._directory).getInteger(2);
        if (value == null) {
            return null;
        }
        return new Rational(value.intValue(), 32678L).toString();
    }

    @Nullable
    public String getDistortionParam04Description() {
        Integer value = ((PanasonicRawDistortionDirectory)this._directory).getInteger(4);
        if (value == null) {
            return null;
        }
        return new Rational(value.intValue(), 32678L).toString();
    }

    @Nullable
    public String getDistortionScaleDescription() {
        Integer value = ((PanasonicRawDistortionDirectory)this._directory).getInteger(5);
        if (value == null) {
            return null;
        }
        return Integer.toString(1 / (1 + value / 32768));
    }

    @Nullable
    public String getDistortionCorrectionDescription() {
        Integer value = ((PanasonicRawDistortionDirectory)this._directory).getInteger(7);
        if (value == null) {
            return null;
        }
        int mask = 15;
        switch (value & mask) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getDistortionParam08Description() {
        Integer value = ((PanasonicRawDistortionDirectory)this._directory).getInteger(8);
        if (value == null) {
            return null;
        }
        return new Rational(value.intValue(), 32678L).toString();
    }

    @Nullable
    public String getDistortionParam09Description() {
        Integer value = ((PanasonicRawDistortionDirectory)this._directory).getInteger(9);
        if (value == null) {
            return null;
        }
        return new Rational(value.intValue(), 32678L).toString();
    }

    @Nullable
    public String getDistortionParam11Description() {
        Integer value = ((PanasonicRawDistortionDirectory)this._directory).getInteger(11);
        if (value == null) {
            return null;
        }
        return new Rational(value.intValue(), 32678L).toString();
    }
}

