/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.exif.makernotes;

import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.TagDescriptor;
import cn.allbs.metadata.metadata.exif.makernotes.CasioType1MakernoteDirectory;

public class CasioType1MakernoteDescriptor
extends TagDescriptor<CasioType1MakernoteDirectory> {
    public CasioType1MakernoteDescriptor(@NotNull CasioType1MakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 1: {
                return this.getRecordingModeDescription();
            }
            case 2: {
                return this.getQualityDescription();
            }
            case 3: {
                return this.getFocusingModeDescription();
            }
            case 4: {
                return this.getFlashModeDescription();
            }
            case 5: {
                return this.getFlashIntensityDescription();
            }
            case 6: {
                return this.getObjectDistanceDescription();
            }
            case 7: {
                return this.getWhiteBalanceDescription();
            }
            case 10: {
                return this.getDigitalZoomDescription();
            }
            case 11: {
                return this.getSharpnessDescription();
            }
            case 12: {
                return this.getContrastDescription();
            }
            case 13: {
                return this.getSaturationDescription();
            }
            case 20: {
                return this.getCcdSensitivityDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getCcdSensitivityDescription() {
        Integer value = ((CasioType1MakernoteDirectory)this._directory).getInteger(20);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 64: {
                return "Normal";
            }
            case 125: {
                return "+1.0";
            }
            case 250: {
                return "+2.0";
            }
            case 244: {
                return "+3.0";
            }
            case 80: {
                return "Normal (ISO 80 equivalent)";
            }
            case 100: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSaturationDescription() {
        return this.getIndexedDescription(13, "Normal", "Low", "High");
    }

    @Nullable
    public String getContrastDescription() {
        return this.getIndexedDescription(12, "Normal", "Low", "High");
    }

    @Nullable
    public String getSharpnessDescription() {
        return this.getIndexedDescription(11, "Normal", "Soft", "Hard");
    }

    @Nullable
    public String getDigitalZoomDescription() {
        Integer value = ((CasioType1MakernoteDirectory)this._directory).getInteger(10);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 65536: {
                return "No digital zoom";
            }
            case 65537: {
                return "2x digital zoom";
            }
            case 131072: {
                return "2x digital zoom";
            }
            case 262144: {
                return "4x digital zoom";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer value = ((CasioType1MakernoteDirectory)this._directory).getInteger(7);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Auto";
            }
            case 2: {
                return "Tungsten";
            }
            case 3: {
                return "Daylight";
            }
            case 4: {
                return "Florescent";
            }
            case 5: {
                return "Shade";
            }
            case 129: {
                return "Manual";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getObjectDistanceDescription() {
        Integer value = ((CasioType1MakernoteDirectory)this._directory).getInteger(6);
        return value == null ? null : CasioType1MakernoteDescriptor.getFocalLengthDescription(value.intValue());
    }

    @Nullable
    public String getFlashIntensityDescription() {
        Integer value = ((CasioType1MakernoteDirectory)this._directory).getInteger(5);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 11: {
                return "Weak";
            }
            case 13: {
                return "Normal";
            }
            case 15: {
                return "Strong";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFlashModeDescription() {
        return this.getIndexedDescription(4, 1, "Auto", "On", "Off", "Red eye reduction");
    }

    @Nullable
    public String getFocusingModeDescription() {
        return this.getIndexedDescription(3, 2, "Macro", "Auto focus", "Manual focus", "Infinity");
    }

    @Nullable
    public String getQualityDescription() {
        return this.getIndexedDescription(2, 1, "Economy", "Normal", "Fine");
    }

    @Nullable
    public String getRecordingModeDescription() {
        return this.getIndexedDescription(1, 1, "Single shutter", "Panorama", "Night scene", "Portrait", "Landscape");
    }
}

