/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.file;

import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.file.FileSystemDirectory;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class FileSystemMetadataReader {
    public void read(@NotNull File file, @NotNull Metadata metadata) throws IOException {
        if (!file.isFile()) {
            throw new IOException("File object must reference a file");
        }
        if (!file.exists()) {
            throw new IOException("File does not exist");
        }
        if (!file.canRead()) {
            throw new IOException("File is not readable");
        }
        FileSystemDirectory directory = metadata.getFirstDirectoryOfType(FileSystemDirectory.class);
        if (directory == null) {
            directory = new FileSystemDirectory();
            metadata.addDirectory(directory);
        }
        directory.setString(1, file.getName());
        directory.setLong(2, file.length());
        directory.setDate(3, new Date(file.lastModified()));
    }
}

