/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.heif.boxes;

import cn.allbs.metadata.lang.ByteArrayReader;
import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.heif.HeifDirectory;
import cn.allbs.metadata.metadata.heif.boxes.Box;
import cn.allbs.metadata.metadata.icc.IccReader;
import java.io.IOException;

public class ColourInformationBox
extends Box {
    String colourType;
    int colourPrimaries;
    int transferCharacteristics;
    int matrixCoefficients;
    int fullRangeFlag;

    public ColourInformationBox(SequentialReader reader, Box box, Metadata metadata) throws IOException {
        super(box);
        this.colourType = reader.getString(4);
        if (this.colourType.equals("nclx")) {
            this.colourPrimaries = reader.getUInt16();
            this.transferCharacteristics = reader.getUInt16();
            this.matrixCoefficients = reader.getUInt16();
            this.fullRangeFlag = (reader.getUInt8() & 0x80) >> 7;
        } else if (this.colourType.equals("rICC")) {
            byte[] buffer = reader.getBytes((int)(this.size - 12L));
            new IccReader().extract(new ByteArrayReader(buffer), metadata);
        } else if (this.colourType.equals("prof")) {
            byte[] buffer = reader.getBytes((int)(this.size - 12L));
            new IccReader().extract(new ByteArrayReader(buffer), metadata);
        }
    }

    public void addMetadata(HeifDirectory directory) {
    }
}

