/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.heif.boxes;

import cn.allbs.metadata.lang.Charsets;
import cn.allbs.metadata.lang.SequentialByteArrayReader;
import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.metadata.heif.HeifDirectory;
import cn.allbs.metadata.metadata.heif.boxes.Box;
import cn.allbs.metadata.metadata.heif.boxes.FullBox;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ItemInfoBox
extends FullBox {
    long entryCount;
    Map<Long, ItemInfoEntry> entries;

    public ItemInfoBox(SequentialReader reader, Box box) throws IOException {
        super(reader, box);
        this.entryCount = this.version == 0 ? (long)reader.getUInt16() : reader.getUInt32();
        this.entries = new HashMap<Long, ItemInfoEntry>();
        int i = 1;
        while ((long)i <= this.entryCount) {
            Box entryBox = new Box(reader);
            SequentialByteArrayReader byteReader = new SequentialByteArrayReader(reader.getBytes((int)entryBox.size - 8));
            ItemInfoEntry itemInfoEntry = new ItemInfoEntry(byteReader, entryBox);
            this.entries.put(itemInfoEntry.itemID, itemInfoEntry);
            ++i;
        }
    }

    public void addMetadata(HeifDirectory directory) {
    }

    public ItemInfoEntry getEntry(long id) {
        return this.entries.get(id);
    }

    public static class ItemInfoEntry
    extends FullBox {
        long itemID;
        long itemProtectionIndex;
        String itemName;
        String contentType;
        String contentEncoding;
        String extensionType;
        String itemType;
        String itemUriType;

        public ItemInfoEntry(SequentialReader reader, Box box) throws IOException {
            super(reader, box);
            int headerLength = 8;
            if (this.version == 0 || this.version == 1) {
                this.itemID = reader.getUInt16();
                this.itemProtectionIndex = reader.getUInt16();
                this.itemName = reader.getNullTerminatedString((int)(box.size - reader.getPosition() - (long)headerLength), Charsets.UTF_8);
                this.contentType = reader.getNullTerminatedString((int)(box.size - reader.getPosition() - (long)headerLength), Charsets.UTF_8);
                if (box.size - reader.getPosition() - (long)headerLength > 0L) {
                    this.extensionType = reader.getNullTerminatedString((int)(box.size - reader.getPosition() - (long)headerLength), Charsets.UTF_8);
                }
            }
            if (this.version == 1 && box.size - 28L >= 4L) {
                this.contentEncoding = reader.getString(4);
            }
            if (this.version >= 2) {
                if (this.version == 2) {
                    this.itemID = reader.getUInt16();
                } else if (this.version == 3) {
                    this.itemID = reader.getUInt32();
                }
                this.itemProtectionIndex = reader.getUInt16();
                this.itemType = reader.getString(4);
                this.itemName = reader.getNullTerminatedString((int)(box.size - reader.getPosition() - (long)headerLength), Charsets.UTF_8);
                if (this.itemType.equals("mime")) {
                    this.contentType = reader.getNullTerminatedString((int)(box.size - reader.getPosition() - (long)headerLength), Charsets.UTF_8);
                    if (box.size - reader.getPosition() - (long)headerLength > 0L) {
                        this.contentEncoding = reader.getNullTerminatedString((int)(box.size - reader.getPosition() - (long)headerLength), Charsets.UTF_8);
                    }
                } else if (this.itemType.equals("uri ")) {
                    this.itemUriType = reader.getString((int)(box.size - reader.getPosition() - (long)headerLength));
                }
            }
        }

        public String getItemType() {
            return this.itemType;
        }
    }
}

