/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.jfif;

import cn.allbs.metadata.imaging.jpeg.JpegSegmentMetadataReader;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentType;
import cn.allbs.metadata.lang.ByteArrayReader;
import cn.allbs.metadata.lang.RandomAccessReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.MetadataReader;
import cn.allbs.metadata.metadata.jfif.JfifDirectory;
import java.io.IOException;
import java.util.Collections;

public class JfifReader
implements JpegSegmentMetadataReader,
MetadataReader {
    public static final String PREAMBLE = "JFIF";

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Collections.singletonList(JpegSegmentType.APP0);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> segments, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        for (byte[] segmentBytes : segments) {
            if (segmentBytes.length < PREAMBLE.length() || !PREAMBLE.equals(new String(segmentBytes, 0, PREAMBLE.length()))) continue;
            this.extract(new ByteArrayReader(segmentBytes), metadata);
        }
    }

    @Override
    public void extract(@NotNull RandomAccessReader reader, @NotNull Metadata metadata) {
        JfifDirectory directory = new JfifDirectory();
        metadata.addDirectory(directory);
        try {
            directory.setInt(5, reader.getUInt16(5));
            directory.setInt(7, reader.getUInt8(7));
            directory.setInt(8, reader.getUInt16(8));
            directory.setInt(10, reader.getUInt16(10));
            directory.setInt(12, reader.getUInt8(12));
            directory.setInt(13, reader.getUInt8(13));
        }
        catch (IOException me) {
            directory.addError(me.getMessage());
        }
    }
}

