/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.jfxx;

import cn.allbs.metadata.imaging.jpeg.JpegSegmentMetadataReader;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentType;
import cn.allbs.metadata.lang.ByteArrayReader;
import cn.allbs.metadata.lang.RandomAccessReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.MetadataReader;
import cn.allbs.metadata.metadata.jfxx.JfxxDirectory;
import java.io.IOException;
import java.util.Collections;

public class JfxxReader
implements JpegSegmentMetadataReader,
MetadataReader {
    public static final String PREAMBLE = "JFXX";

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Collections.singletonList(JpegSegmentType.APP0);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> segments, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        for (byte[] segmentBytes : segments) {
            if (segmentBytes.length < PREAMBLE.length() || !PREAMBLE.equals(new String(segmentBytes, 0, PREAMBLE.length()))) continue;
            this.extract(new ByteArrayReader(segmentBytes), metadata);
        }
    }

    @Override
    public void extract(@NotNull RandomAccessReader reader, @NotNull Metadata metadata) {
        JfxxDirectory directory = new JfxxDirectory();
        metadata.addDirectory(directory);
        try {
            directory.setInt(5, reader.getUInt8(5));
        }
        catch (IOException me) {
            directory.addError(me.getMessage());
        }
    }
}

