/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.mov.atoms.canon;

import cn.allbs.metadata.imaging.jpeg.JpegProcessingException;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentData;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentReader;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentType;
import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.lang.StreamReader;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.Tag;
import cn.allbs.metadata.metadata.exif.ExifIFD0Directory;
import cn.allbs.metadata.metadata.exif.ExifReader;
import cn.allbs.metadata.metadata.mov.QuickTimeDirectory;
import cn.allbs.metadata.metadata.mov.atoms.Atom;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashSet;

public class CanonThumbnailAtom
extends Atom {
    private String dateTime;

    public CanonThumbnailAtom(SequentialReader reader) throws IOException {
        super(reader);
        this.readCNDA(reader);
    }

    private void readCNDA(SequentialReader reader) throws IOException {
        if (this.type.compareTo("CNDA") == 0) {
            JpegSegmentData segmentData;
            ExifReader exifReader = new ExifReader();
            ByteArrayInputStream exifStream = new ByteArrayInputStream(reader.getBytes((int)this.size));
            HashSet<JpegSegmentType> segmentTypes = new HashSet<JpegSegmentType>();
            for (JpegSegmentType type : exifReader.getSegmentTypes()) {
                segmentTypes.add(type);
            }
            try {
                segmentData = JpegSegmentReader.readSegments(new StreamReader(exifStream), segmentTypes);
            }
            catch (JpegProcessingException e) {
                return;
            }
            Metadata metadata = new Metadata();
            for (JpegSegmentType segmentType : exifReader.getSegmentTypes()) {
                exifReader.readJpegSegments(segmentData.getSegments(segmentType), metadata, segmentType);
            }
            ExifIFD0Directory directory = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            if (directory != null) {
                for (Tag tag : directory.getTags()) {
                    if (tag.getTagType() != 306) continue;
                    this.dateTime = tag.getDescription();
                }
            }
        }
    }

    public void addMetadata(QuickTimeDirectory directory) {
        directory.setString(8192, this.dateTime);
    }
}

