/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.mov.media;

import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.mov.QuickTimeDescriptor;
import cn.allbs.metadata.metadata.mov.QuickTimeDirectory;
import cn.allbs.metadata.metadata.mov.media.QuickTimeVideoDirectory;

public class QuickTimeVideoDescriptor
extends QuickTimeDescriptor {
    public QuickTimeVideoDescriptor(@NotNull QuickTimeVideoDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 4: 
            case 5: {
                return this.getPixelDescription(tagType);
            }
            case 9: {
                return this.getDepthDescription(tagType);
            }
            case 13: {
                return this.getColorTableDescription(tagType);
            }
            case 11: {
                return this.getGraphicsModeDescription();
            }
        }
        return super.getDescription(tagType);
    }

    private String getPixelDescription(int tagType) {
        String value = ((QuickTimeDirectory)this._directory).getString(tagType);
        return value == null ? null : value + " pixels";
    }

    private String getDepthDescription(int tagType) {
        Integer value = ((QuickTimeDirectory)this._directory).getInteger(tagType);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 24: 
            case 32: {
                return value + "-bit color";
            }
            case 34: 
            case 36: 
            case 40: {
                return value - 32 + "-bit grayscale";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getColorTableDescription(int tagType) {
        Integer value = ((QuickTimeDirectory)this._directory).getInteger(tagType);
        if (value == null) {
            return null;
        }
        switch (value) {
            case -1: {
                if (((QuickTimeDirectory)this._directory).getInteger(9) < 16) {
                    return "Default";
                }
                return "None";
            }
            case 0: {
                return "Color table within file";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getGraphicsModeDescription() {
        Integer value = ((QuickTimeDirectory)this._directory).getInteger(11);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Copy";
            }
            case 64: {
                return "Dither copy";
            }
            case 32: {
                return "Blend";
            }
            case 36: {
                return "Transparent";
            }
            case 256: {
                return "Straight alpha";
            }
            case 257: {
                return "Premul white alpha";
            }
            case 258: {
                return "Premul black alpha";
            }
            case 260: {
                return "Straight alpha blend";
            }
            case 259: {
                return "Composition (dither copy)";
            }
        }
        return "Unknown (" + value + ")";
    }
}

