/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.mp4.media;

import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.TagDescriptor;
import cn.allbs.metadata.metadata.mp4.media.Mp4VideoDirectory;

public class Mp4VideoDescriptor
extends TagDescriptor<Mp4VideoDirectory> {
    public Mp4VideoDescriptor(@NotNull Mp4VideoDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 204: 
            case 205: {
                return this.getPixelDescription(tagType);
            }
            case 209: {
                return this.getDepthDescription();
            }
            case 213: {
                return this.getColorTableDescription();
            }
            case 211: {
                return this.getGraphicsModeDescription();
            }
        }
        return super.getDescription(tagType);
    }

    private String getPixelDescription(int tagType) {
        String value = ((Mp4VideoDirectory)this._directory).getString(tagType);
        return value == null ? null : value + " pixels";
    }

    private String getDepthDescription() {
        Integer value = ((Mp4VideoDirectory)this._directory).getInteger(209);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 24: 
            case 32: {
                return value + "-bit color";
            }
            case 34: 
            case 36: 
            case 40: {
                return value - 32 + "-bit grayscale";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getColorTableDescription() {
        Integer value = ((Mp4VideoDirectory)this._directory).getInteger(213);
        if (value == null) {
            return null;
        }
        switch (value) {
            case -1: {
                Integer depth = ((Mp4VideoDirectory)this._directory).getInteger(209);
                if (depth == null) {
                    return "None";
                }
                if (depth < 16) {
                    return "Default";
                }
                return "None";
            }
            case 0: {
                return "Color table within file";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getGraphicsModeDescription() {
        Integer value = ((Mp4VideoDirectory)this._directory).getInteger(211);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Copy";
            }
            case 64: {
                return "Dither copy";
            }
            case 32: {
                return "Blend";
            }
            case 36: {
                return "Transparent";
            }
            case 256: {
                return "Straight alpha";
            }
            case 257: {
                return "Premul white alpha";
            }
            case 258: {
                return "Premul black alpha";
            }
            case 260: {
                return "Straight alpha blend";
            }
            case 259: {
                return "Composition (dither copy)";
            }
        }
        return "Unknown (" + value + ")";
    }
}

