/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.photoshop;

import cn.allbs.metadata.imaging.ImageProcessingException;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentMetadataReader;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentType;
import cn.allbs.metadata.lang.ByteArrayReader;
import cn.allbs.metadata.lang.SequentialByteArrayReader;
import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.Directory;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.exif.ExifReader;
import cn.allbs.metadata.metadata.icc.IccReader;
import cn.allbs.metadata.metadata.iptc.IptcReader;
import cn.allbs.metadata.metadata.photoshop.PhotoshopDirectory;
import cn.allbs.metadata.metadata.xmp.XmpReader;
import java.util.Arrays;
import java.util.Collections;

public class PhotoshopReader
implements JpegSegmentMetadataReader {
    @NotNull
    private static final String JPEG_SEGMENT_PREAMBLE = "Photoshop 3.0";

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Collections.singletonList(JpegSegmentType.APPD);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> segments, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        int preambleLength = JPEG_SEGMENT_PREAMBLE.length();
        for (byte[] segmentBytes : segments) {
            if (segmentBytes.length < preambleLength + 1 || !JPEG_SEGMENT_PREAMBLE.equals(new String(segmentBytes, 0, preambleLength))) continue;
            this.extract(new SequentialByteArrayReader(segmentBytes, preambleLength + 1), segmentBytes.length - preambleLength - 1, metadata);
        }
    }

    public void extract(@NotNull SequentialReader reader, int length, @NotNull Metadata metadata) {
        this.extract(reader, length, metadata, null);
    }

    public void extract(@NotNull SequentialReader reader, int length, @NotNull Metadata metadata, @Nullable Directory parentDirectory) {
        PhotoshopDirectory directory = new PhotoshopDirectory();
        metadata.addDirectory(directory);
        if (parentDirectory != null) {
            directory.setParent(parentDirectory);
        }
        int pos = 0;
        int clippingPathCount = 0;
        while (pos < length) {
            try {
                String signature = reader.getString(4);
                pos += 4;
                int tagType = reader.getUInt16();
                pos += 2;
                int descriptionLength = reader.getUInt8();
                if (descriptionLength < 0 || descriptionLength + ++pos > length) {
                    throw new ImageProcessingException("Invalid string length");
                }
                StringBuilder description = new StringBuilder();
                descriptionLength += pos;
                while (pos < descriptionLength) {
                    description.append((char)reader.getUInt8());
                    ++pos;
                }
                if (pos % 2 != 0) {
                    reader.skip(1L);
                    ++pos;
                }
                int byteCount = reader.getInt32();
                pos += 4;
                byte[] tagBytes = reader.getBytes(byteCount);
                if ((pos += byteCount) % 2 != 0) {
                    reader.skip(1L);
                    ++pos;
                }
                if (!signature.equals("8BIM")) continue;
                if (tagType == 1028) {
                    new IptcReader().extract(new SequentialByteArrayReader(tagBytes), metadata, tagBytes.length, directory);
                } else if (tagType == 1039) {
                    new IccReader().extract(new ByteArrayReader(tagBytes), metadata, directory);
                } else if (tagType == 1058 || tagType == 1059) {
                    new ExifReader().extract(new ByteArrayReader(tagBytes), metadata, 0, directory);
                } else if (tagType == 1060) {
                    new XmpReader().extract(tagBytes, metadata, (Directory)directory);
                } else if (tagType >= 2000 && tagType <= 2998) {
                    ++clippingPathCount;
                    tagBytes = Arrays.copyOf(tagBytes, tagBytes.length + description.length() + 1);
                    for (int i = tagBytes.length - description.length() - 1; i < tagBytes.length; ++i) {
                        tagBytes[i] = i % (tagBytes.length - description.length() - 1 + description.length()) == 0 ? (byte)description.length() : (byte)description.charAt(i - (tagBytes.length - description.length() - 1));
                    }
                    PhotoshopDirectory._tagNameMap.put(1999 + clippingPathCount, "Path Info " + clippingPathCount);
                    directory.setByteArray(1999 + clippingPathCount, tagBytes);
                } else {
                    directory.setByteArray(tagType, tagBytes);
                }
                if (tagType < 4000 || tagType > 4999) continue;
                PhotoshopDirectory._tagNameMap.put(tagType, String.format("Plug-in %d Data", tagType - 4000 + 1));
            }
            catch (Exception ex) {
                directory.addError(ex.getMessage());
                return;
            }
        }
    }
}

