/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.photoshop;

import cn.allbs.metadata.lang.ByteArrayReader;
import cn.allbs.metadata.lang.RandomAccessReader;
import cn.allbs.metadata.lang.SequentialByteArrayReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.Directory;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.exif.ExifTiffHandler;
import cn.allbs.metadata.metadata.icc.IccReader;
import cn.allbs.metadata.metadata.photoshop.PhotoshopReader;
import cn.allbs.metadata.metadata.xmp.XmpReader;
import java.io.IOException;
import java.util.Set;

public class PhotoshopTiffHandler
extends ExifTiffHandler {
    private static final int TAG_PAGE_MAKER_EXTENSION = 330;
    private static final int TAG_JPEG_TABLES = 437;
    private static final int TAG_XMP = 700;
    private static final int TAG_FILE_INFORMATION = 33723;
    private static final int TAG_PHOTOSHOP_IMAGE_RESOURCES = 34377;
    private static final int TAG_EXIF_IFD_POINTER = 34665;
    private static final int TAG_ICC_PROFILES = 34675;
    private static final int TAG_EXIF_GPS = 34853;
    private static final int TAG_T_IMAGE_SOURCE_DATA = 37724;
    private static final int TAG_T_ANNOTATIONS = 50255;

    public PhotoshopTiffHandler(Metadata metadata, Directory parentDirectory) {
        super(metadata, parentDirectory);
    }

    @Override
    public boolean customProcessTag(int tagOffset, @NotNull Set<Integer> processedIfdOffsets, int tiffHeaderOffset, @NotNull RandomAccessReader reader, int tagId, int byteCount) throws IOException {
        switch (tagId) {
            case 700: {
                new XmpReader().extract(reader.getBytes(tagOffset, byteCount), this._metadata);
                return true;
            }
            case 34377: {
                new PhotoshopReader().extract(new SequentialByteArrayReader(reader.getBytes(tagOffset, byteCount)), byteCount, this._metadata);
                return true;
            }
            case 34675: {
                new IccReader().extract(new ByteArrayReader(reader.getBytes(tagOffset, byteCount)), this._metadata);
                return true;
            }
        }
        return super.customProcessTag(tagOffset, processedIfdOffsets, tiffHeaderOffset, reader, tagId, byteCount);
    }
}

