/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.webp;

import cn.allbs.metadata.imaging.riff.RiffHandler;
import cn.allbs.metadata.lang.ByteArrayReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.exif.ExifReader;
import cn.allbs.metadata.metadata.icc.IccReader;
import cn.allbs.metadata.metadata.webp.WebpDirectory;
import cn.allbs.metadata.metadata.xmp.XmpReader;
import java.io.IOException;

public class WebpRiffHandler
implements RiffHandler {
    @NotNull
    private final Metadata _metadata;

    public WebpRiffHandler(@NotNull Metadata metadata) {
        this._metadata = metadata;
    }

    @Override
    public boolean shouldAcceptRiffIdentifier(@NotNull String identifier) {
        return identifier.equals("WEBP");
    }

    @Override
    public boolean shouldAcceptChunk(@NotNull String fourCC) {
        return fourCC.equals("VP8X") || fourCC.equals("VP8L") || fourCC.equals("VP8 ") || fourCC.equals("EXIF") || fourCC.equals("ICCP") || fourCC.equals("XMP ");
    }

    @Override
    public boolean shouldAcceptList(@NotNull String fourCC) {
        return false;
    }

    @Override
    public void processChunk(@NotNull String fourCC, @NotNull byte[] payload) {
        WebpDirectory directory = new WebpDirectory();
        if (fourCC.equals("EXIF")) {
            ByteArrayReader reader = ExifReader.startsWithJpegExifPreamble(payload) ? new ByteArrayReader(payload, "Exif\u0000\u0000".length()) : new ByteArrayReader(payload);
            new ExifReader().extract(reader, this._metadata);
        } else if (fourCC.equals("ICCP")) {
            new IccReader().extract(new ByteArrayReader(payload), this._metadata);
        } else if (fourCC.equals("XMP ")) {
            new XmpReader().extract(payload, this._metadata);
        } else if (fourCC.equals("VP8X") && payload.length == 10) {
            ByteArrayReader reader = new ByteArrayReader(payload);
            reader.setMotorolaByteOrder(false);
            try {
                boolean isAnimation = reader.getBit(1);
                boolean hasAlpha = reader.getBit(4);
                int widthMinusOne = reader.getInt24(4);
                int heightMinusOne = reader.getInt24(7);
                directory.setInt(2, widthMinusOne + 1);
                directory.setInt(1, heightMinusOne + 1);
                directory.setBoolean(3, hasAlpha);
                directory.setBoolean(4, isAnimation);
                this._metadata.addDirectory(directory);
            }
            catch (IOException e) {
                directory.addError(e.getMessage());
            }
        } else if (fourCC.equals("VP8L") && payload.length > 4) {
            ByteArrayReader reader = new ByteArrayReader(payload);
            reader.setMotorolaByteOrder(false);
            try {
                if (reader.getInt8(0) != 47) {
                    return;
                }
                short b1 = reader.getUInt8(1);
                short b2 = reader.getUInt8(2);
                short b3 = reader.getUInt8(3);
                short b4 = reader.getUInt8(4);
                int widthMinusOne = (b2 & 0x3F) << 8 | b1;
                int heightMinusOne = (b4 & 0xF) << 10 | b3 << 2 | (b2 & 0xC0) >> 6;
                directory.setInt(2, widthMinusOne + 1);
                directory.setInt(1, heightMinusOne + 1);
                this._metadata.addDirectory(directory);
            }
            catch (IOException e) {
                directory.addError(e.getMessage());
            }
        } else if (fourCC.equals("VP8 ") && payload.length > 9) {
            ByteArrayReader reader = new ByteArrayReader(payload);
            reader.setMotorolaByteOrder(false);
            try {
                if (reader.getUInt8(3) != 157 || reader.getUInt8(4) != 1 || reader.getUInt8(5) != 42) {
                    return;
                }
                int width = reader.getUInt16(6);
                int height = reader.getUInt16(8);
                directory.setInt(2, width);
                directory.setInt(1, height);
                this._metadata.addDirectory(directory);
            }
            catch (IOException ex) {
                directory.addError(ex.getMessage());
            }
        }
    }
}

