/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.imaging.jpeg;

import cn.allbs.metadata.imaging.jpeg.JpegProcessingException;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentData;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentType;
import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.lang.StreamReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;

public class JpegSegmentReader {
    private static final byte SEGMENT_IDENTIFIER = -1;
    private static final byte SEGMENT_SOS = -38;
    private static final byte MARKER_EOI = -39;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JpegSegmentData readSegments(@NotNull File file, @Nullable Iterable<JpegSegmentType> segmentTypes) throws JpegProcessingException, IOException {
        try (FileInputStream stream = null;){
            stream = new FileInputStream(file);
            JpegSegmentData jpegSegmentData = JpegSegmentReader.readSegments(new StreamReader(stream), segmentTypes);
            return jpegSegmentData;
        }
    }

    @NotNull
    public static JpegSegmentData readSegments(@NotNull SequentialReader reader, @Nullable Iterable<JpegSegmentType> segmentTypes) throws JpegProcessingException, IOException {
        assert (reader.isMotorolaByteOrder());
        int magicNumber = reader.getUInt16();
        if (magicNumber != 65496) {
            throw new JpegProcessingException("JPEG data is expected to begin with 0xFFD8 (\u00ff\u00d8) not 0x" + Integer.toHexString(magicNumber));
        }
        HashSet<Byte> segmentTypeBytes = null;
        if (segmentTypes != null) {
            segmentTypeBytes = new HashSet<Byte>();
            for (JpegSegmentType segmentType : segmentTypes) {
                segmentTypeBytes.add(segmentType.byteValue);
            }
        }
        JpegSegmentData segmentData = new JpegSegmentData();
        while (true) {
            byte segmentIdentifier = reader.getInt8();
            byte segmentType = reader.getInt8();
            while (segmentIdentifier != -1 || segmentType == -1 || segmentType == 0) {
                segmentIdentifier = segmentType;
                segmentType = reader.getInt8();
            }
            if (segmentType == -38) {
                return segmentData;
            }
            if (segmentType == -39) {
                return segmentData;
            }
            int segmentLength = reader.getUInt16();
            if ((segmentLength -= 2) < 0) {
                throw new JpegProcessingException("JPEG segment size would be less than zero");
            }
            if (segmentTypeBytes == null || segmentTypeBytes.contains(segmentType)) {
                byte[] segmentBytes = reader.getBytes(segmentLength);
                assert (segmentLength == segmentBytes.length);
                segmentData.addSegment(segmentType, segmentBytes);
                continue;
            }
            if (!reader.trySkip(segmentLength)) break;
        }
        return segmentData;
    }

    private JpegSegmentReader() throws Exception {
        throw new Exception("Not intended for instantiation.");
    }
}

