/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.imaging.quicktime;

import cn.allbs.metadata.imaging.quicktime.QuickTimeHandler;
import cn.allbs.metadata.lang.StreamReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.mov.QuickTimeContext;
import cn.allbs.metadata.metadata.mov.atoms.Atom;
import java.io.IOException;
import java.io.InputStream;

public class QuickTimeReader {
    private QuickTimeReader() {
    }

    public static void extract(@NotNull InputStream inputStream, @NotNull QuickTimeHandler<?> handler) {
        StreamReader reader = new StreamReader(inputStream);
        reader.setMotorolaByteOrder(true);
        QuickTimeContext context = new QuickTimeContext();
        QuickTimeReader.processAtoms(reader, -1L, handler, context);
    }

    private static void processAtoms(StreamReader reader, long atomEnd, QuickTimeHandler<?> handler, QuickTimeContext context) {
        try {
            while (atomEnd == -1L || reader.getPosition() < atomEnd) {
                Atom atom = new Atom(reader);
                if (handler.shouldAcceptContainer(atom)) {
                    QuickTimeReader.processAtoms(reader, atom.size + reader.getPosition() - 8L, handler.processContainer(atom, context), context);
                    continue;
                }
                if (handler.shouldAcceptAtom(atom)) {
                    handler = handler.processAtom(atom, reader.getBytes((int)atom.size - 8), context);
                    continue;
                }
                if (atom.size > 1L) {
                    reader.skip(atom.size - 8L);
                    continue;
                }
                if (atom.size != -1L) continue;
                break;
            }
        }
        catch (IOException e) {
            handler.addError(e.getMessage());
        }
    }
}

