/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.imaging.tiff;

import cn.allbs.metadata.imaging.tiff.TiffProcessingException;
import cn.allbs.metadata.imaging.tiff.TiffReader;
import cn.allbs.metadata.lang.RandomAccessFileReader;
import cn.allbs.metadata.lang.RandomAccessReader;
import cn.allbs.metadata.lang.RandomAccessStreamReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.exif.ExifTiffHandler;
import cn.allbs.metadata.metadata.file.FileSystemMetadataReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class TiffMetadataReader {
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws IOException, TiffProcessingException {
        Metadata metadata;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            metadata = TiffMetadataReader.readMetadata(new RandomAccessFileReader(randomAccessFile));
        }
        new FileSystemMetadataReader().read(file, metadata);
        return metadata;
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws IOException, TiffProcessingException {
        return TiffMetadataReader.readMetadata(new RandomAccessStreamReader(inputStream));
    }

    @NotNull
    public static Metadata readMetadata(@NotNull RandomAccessReader reader) throws IOException, TiffProcessingException {
        Metadata metadata = new Metadata();
        ExifTiffHandler handler = new ExifTiffHandler(metadata, null);
        new TiffReader().processTiff(reader, handler, 0);
        return metadata;
    }
}

