/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.imaging.webp;

import cn.allbs.metadata.imaging.riff.RiffProcessingException;
import cn.allbs.metadata.imaging.riff.RiffReader;
import cn.allbs.metadata.lang.StreamReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.file.FileSystemMetadataReader;
import cn.allbs.metadata.metadata.webp.WebpRiffHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class WebpMetadataReader {
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws IOException, RiffProcessingException {
        Metadata metadata;
        try (FileInputStream inputStream = new FileInputStream(file);){
            metadata = WebpMetadataReader.readMetadata(inputStream);
        }
        new FileSystemMetadataReader().read(file, metadata);
        return metadata;
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws IOException, RiffProcessingException {
        Metadata metadata = new Metadata();
        new RiffReader().processRiff(new StreamReader(inputStream), new WebpRiffHandler(metadata));
        return metadata;
    }
}

