/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.lang;

import cn.allbs.metadata.lang.Rational;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import java.text.DecimalFormat;

public final class GeoLocation {
    private final double _latitude;
    private final double _longitude;

    public GeoLocation(double latitude, double longitude) {
        this._latitude = latitude;
        this._longitude = longitude;
    }

    public double getLatitude() {
        return this._latitude;
    }

    public double getLongitude() {
        return this._longitude;
    }

    public boolean isZero() {
        return this._latitude == 0.0 && this._longitude == 0.0;
    }

    @NotNull
    public static String decimalToDegreesMinutesSecondsString(double decimal) {
        double[] dms = GeoLocation.decimalToDegreesMinutesSeconds(decimal);
        DecimalFormat format = new DecimalFormat("0.##");
        return String.format("%s\u00b0 %s' %s\"", format.format(dms[0]), format.format(dms[1]), format.format(dms[2]));
    }

    @NotNull
    public static double[] decimalToDegreesMinutesSeconds(double decimal) {
        int d = (int)decimal;
        double m = Math.abs(decimal % 1.0 * 60.0);
        double s = m % 1.0 * 60.0;
        return new double[]{d, (int)m, s};
    }

    @Nullable
    public static Double degreesMinutesSecondsToDecimal(@NotNull Rational degs, @NotNull Rational mins, @NotNull Rational secs, boolean isNegative) {
        double decimal = Math.abs(degs.doubleValue()) + mins.doubleValue() / 60.0 + secs.doubleValue() / 3600.0;
        if (Double.isNaN(decimal)) {
            return null;
        }
        if (isNegative) {
            decimal *= -1.0;
        }
        return decimal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoLocation that = (GeoLocation)o;
        if (Double.compare(that._latitude, this._latitude) != 0) {
            return false;
        }
        return Double.compare(that._longitude, this._longitude) == 0;
    }

    public int hashCode() {
        long temp = this._latitude != 0.0 ? Double.doubleToLongBits(this._latitude) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this._longitude != 0.0 ? Double.doubleToLongBits(this._longitude) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @NotNull
    public String toString() {
        return this._latitude + ", " + this._longitude;
    }

    @NotNull
    public String toDMSString() {
        return GeoLocation.decimalToDegreesMinutesSecondsString(this._latitude) + ", " + GeoLocation.decimalToDegreesMinutesSecondsString(this._longitude);
    }
}

