/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.apple;

import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.Directory;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.exif.makernotes.AppleRunTimeMakernoteDirectory;
import cn.allbs.metadata.metadata.plist.BplistReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AppleRunTimeReader {
    public void extract(@NotNull byte[] bytes, @NotNull Metadata metadata, @NotNull Directory parentDirectory) {
        parentDirectory.setByteArray(3, bytes);
        if (!BplistReader.isValid(bytes)) {
            parentDirectory.addError("Input array is not a bplist");
            return;
        }
        AppleRunTimeMakernoteDirectory directory = new AppleRunTimeMakernoteDirectory();
        directory.setParent(parentDirectory);
        try {
            AppleRunTimeReader.processAppleRunTime(directory, bytes);
            if (directory.getTagCount() > 0) {
                metadata.addDirectory(directory);
            }
        }
        catch (IOException e) {
            parentDirectory.addError("Error processing TAG_RUN_TIME: " + e.getMessage());
        }
    }

    private static void processAppleRunTime(@NotNull AppleRunTimeMakernoteDirectory directory, @NotNull byte[] bplist) throws IOException {
        BplistReader.PropertyListResults results = BplistReader.parse(bplist);
        Set<Map.Entry<Byte, Byte>> entrySet = results.getEntrySet();
        if (entrySet != null) {
            HashMap<String, Object> values = new HashMap<String, Object>(entrySet.size());
            for (Map.Entry<Byte, Byte> entry : entrySet) {
                String key = (String)results.getObjects().get(entry.getKey().byteValue());
                Object value = results.getObjects().get(entry.getValue().byteValue());
                values.put(key, value);
            }
            byte flags = (Byte)values.get("flags");
            if ((flags & 1) == 1) {
                directory.setInt(1, flags);
                directory.setInt(2, ((Byte)values.get("epoch")).byteValue());
                directory.setLong(3, (Long)values.get("timescale"));
                directory.setLong(4, (Long)values.get("value"));
            }
        }
    }
}

