/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.bmp;

import cn.allbs.metadata.lang.ByteArrayReader;
import cn.allbs.metadata.lang.Charsets;
import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.ErrorDirectory;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.MetadataException;
import cn.allbs.metadata.metadata.bmp.BmpHeaderDirectory;
import cn.allbs.metadata.metadata.icc.IccReader;
import java.io.IOException;

public class BmpReader {
    public static final int BITMAP = 19778;
    public static final int OS2_BITMAP_ARRAY = 16706;
    public static final int OS2_ICON = 17225;
    public static final int OS2_COLOR_ICON = 18755;
    public static final int OS2_COLOR_POINTER = 20547;
    public static final int OS2_POINTER = 21584;

    public void extract(@NotNull SequentialReader reader, @NotNull Metadata metadata) {
        reader.setMotorolaByteOrder(false);
        this.readFileHeader(reader, metadata, true);
    }

    protected void readFileHeader(@NotNull SequentialReader reader, @NotNull Metadata metadata, boolean allowArray) {
        int magicNumber;
        try {
            magicNumber = reader.getUInt16();
        }
        catch (IOException e) {
            metadata.addDirectory(new ErrorDirectory("Couldn't determine bitmap type: " + e.getMessage()));
            return;
        }
        BmpHeaderDirectory directory = null;
        try {
            switch (magicNumber) {
                case 16706: {
                    if (!allowArray) {
                        this.addError("Invalid bitmap file - nested arrays not allowed", metadata);
                        return;
                    }
                    reader.skip(4L);
                    long nextHeaderOffset = reader.getUInt32();
                    reader.skip(4L);
                    this.readFileHeader(reader, metadata, false);
                    if (nextHeaderOffset == 0L) {
                        return;
                    }
                    if (reader.getPosition() > nextHeaderOffset) {
                        this.addError("Invalid next header offset", metadata);
                        return;
                    }
                    reader.skip(nextHeaderOffset - reader.getPosition());
                    this.readFileHeader(reader, metadata, true);
                    break;
                }
                case 17225: 
                case 18755: 
                case 19778: 
                case 20547: 
                case 21584: {
                    directory = new BmpHeaderDirectory();
                    metadata.addDirectory(directory);
                    directory.setInt(-2, magicNumber);
                    reader.skip(12L);
                    this.readBitmapHeader(reader, directory, metadata);
                    break;
                }
                default: {
                    metadata.addDirectory(new ErrorDirectory("Invalid BMP magic number 0x" + Integer.toHexString(magicNumber)));
                    return;
                }
            }
        }
        catch (IOException e) {
            if (directory == null) {
                this.addError("Unable to read BMP file header", metadata);
            }
            directory.addError("Unable to read BMP file header");
        }
    }

    protected void readBitmapHeader(@NotNull SequentialReader reader, @NotNull BmpHeaderDirectory directory, @NotNull Metadata metadata) {
        try {
            int bitmapType = directory.getInt(-2);
            long headerOffset = reader.getPosition();
            int headerSize = reader.getInt32();
            directory.setInt(-1, headerSize);
            if (headerSize == 12 && bitmapType == 19778) {
                directory.setInt(2, reader.getInt16());
                directory.setInt(1, reader.getInt16());
                directory.setInt(3, reader.getUInt16());
                directory.setInt(4, reader.getUInt16());
            } else if (headerSize == 12) {
                directory.setInt(2, reader.getUInt16());
                directory.setInt(1, reader.getUInt16());
                directory.setInt(3, reader.getUInt16());
                directory.setInt(4, reader.getUInt16());
            } else if (headerSize == 16 || headerSize == 64) {
                directory.setInt(2, reader.getInt32());
                directory.setInt(1, reader.getInt32());
                directory.setInt(3, reader.getUInt16());
                directory.setInt(4, reader.getUInt16());
                if (headerSize > 16) {
                    directory.setInt(5, reader.getInt32());
                    reader.skip(4L);
                    directory.setInt(6, reader.getInt32());
                    directory.setInt(7, reader.getInt32());
                    directory.setInt(8, reader.getInt32());
                    directory.setInt(9, reader.getInt32());
                    reader.skip(6L);
                    directory.setInt(10, reader.getUInt16());
                    reader.skip(8L);
                    directory.setInt(11, reader.getInt32());
                    reader.skip(4L);
                }
            } else if (headerSize == 40 || headerSize == 52 || headerSize == 56 || headerSize == 108 || headerSize == 124) {
                directory.setInt(2, reader.getInt32());
                directory.setInt(1, reader.getInt32());
                directory.setInt(3, reader.getUInt16());
                directory.setInt(4, reader.getUInt16());
                directory.setInt(5, reader.getInt32());
                reader.skip(4L);
                directory.setInt(6, reader.getInt32());
                directory.setInt(7, reader.getInt32());
                directory.setInt(8, reader.getInt32());
                directory.setInt(9, reader.getInt32());
                if (headerSize == 40) {
                    return;
                }
                directory.setLong(12, reader.getUInt32());
                directory.setLong(13, reader.getUInt32());
                directory.setLong(14, reader.getUInt32());
                if (headerSize == 52) {
                    return;
                }
                directory.setLong(15, reader.getUInt32());
                if (headerSize == 56) {
                    return;
                }
                long csType = reader.getUInt32();
                directory.setLong(16, csType);
                reader.skip(36L);
                directory.setLong(17, reader.getUInt32());
                directory.setLong(18, reader.getUInt32());
                directory.setLong(19, reader.getUInt32());
                if (headerSize == 108) {
                    return;
                }
                directory.setInt(20, reader.getInt32());
                if (csType == BmpHeaderDirectory.ColorSpaceType.PROFILE_EMBEDDED.getValue() || csType == BmpHeaderDirectory.ColorSpaceType.PROFILE_LINKED.getValue()) {
                    long profileOffset = reader.getUInt32();
                    int profileSize = reader.getInt32();
                    if (reader.getPosition() > headerOffset + profileOffset) {
                        directory.addError("Invalid profile data offset 0x" + Long.toHexString(headerOffset + profileOffset));
                        return;
                    }
                    reader.skip(headerOffset + profileOffset - reader.getPosition());
                    if (csType == BmpHeaderDirectory.ColorSpaceType.PROFILE_LINKED.getValue()) {
                        directory.setString(21, reader.getNullTerminatedString(profileSize, Charsets.WINDOWS_1252));
                    } else {
                        ByteArrayReader randomAccessReader = new ByteArrayReader(reader.getBytes(profileSize));
                        new IccReader().extract(randomAccessReader, metadata, directory);
                    }
                } else {
                    reader.skip(12L);
                }
            } else {
                directory.addError("Unexpected DIB header size: " + headerSize);
            }
        }
        catch (IOException e) {
            directory.addError("Unable to read BMP header");
        }
        catch (MetadataException e) {
            directory.addError("Internal error");
        }
    }

    protected void addError(@NotNull String errorMessage, @NotNull Metadata metadata) {
        ErrorDirectory directory = metadata.getFirstDirectoryOfType(ErrorDirectory.class);
        if (directory == null) {
            metadata.addDirectory(new ErrorDirectory(errorMessage));
        } else {
            directory.addError(errorMessage);
        }
    }
}

