/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.exif.makernotes;

import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.TagDescriptor;
import cn.allbs.metadata.metadata.exif.makernotes.LeicaMakernoteDirectory;

public class LeicaMakernoteDescriptor
extends TagDescriptor<LeicaMakernoteDirectory> {
    public LeicaMakernoteDescriptor(@NotNull LeicaMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 768: {
                return this.getQualityDescription();
            }
            case 770: {
                return this.getUserProfileDescription();
            }
            case 772: {
                return this.getWhiteBalanceDescription();
            }
            case 785: {
                return this.getExternalSensorBrightnessValueDescription();
            }
            case 786: {
                return this.getMeasuredLvDescription();
            }
            case 787: {
                return this.getApproximateFNumberDescription();
            }
            case 800: {
                return this.getCameraTemperatureDescription();
            }
            case 802: 
            case 803: 
            case 804: {
                return this.getSimpleRational(tagType);
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    private String getCameraTemperatureDescription() {
        return this.getFormattedInt(800, "%d C");
    }

    @Nullable
    private String getApproximateFNumberDescription() {
        return this.getSimpleRational(787);
    }

    @Nullable
    private String getMeasuredLvDescription() {
        return this.getSimpleRational(786);
    }

    @Nullable
    private String getExternalSensorBrightnessValueDescription() {
        return this.getSimpleRational(785);
    }

    @Nullable
    private String getWhiteBalanceDescription() {
        return this.getIndexedDescription(772, "Auto or Manual", "Daylight", "Fluorescent", "Tungsten", "Flash", "Cloudy", "Shadow");
    }

    @Nullable
    private String getUserProfileDescription() {
        return this.getIndexedDescription(768, 1, "User Profile 1", "User Profile 2", "User Profile 3", "User Profile 0 (Dynamic)");
    }

    @Nullable
    private String getQualityDescription() {
        return this.getIndexedDescription(768, 1, "Fine", "Basic");
    }
}

