/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.exif.makernotes;

import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.StringValue;
import cn.allbs.metadata.metadata.TagDescriptor;
import cn.allbs.metadata.metadata.exif.makernotes.ReconyxHyperFire2MakernoteDirectory;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class ReconyxHyperFire2MakernoteDescriptor
extends TagDescriptor<ReconyxHyperFire2MakernoteDirectory> {
    public ReconyxHyperFire2MakernoteDescriptor(@NotNull ReconyxHyperFire2MakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 16: {
                return String.format("%d", ((ReconyxHyperFire2MakernoteDirectory)this._directory).getInteger(tagType));
            }
            case 18: {
                return String.format("%d", ((ReconyxHyperFire2MakernoteDirectory)this._directory).getInteger(tagType));
            }
            case 42: {
                return ((ReconyxHyperFire2MakernoteDirectory)this._directory).getString(tagType);
            }
            case 48: {
                String dtFirm = ((ReconyxHyperFire2MakernoteDirectory)this._directory).getString(tagType);
                try {
                    SimpleDateFormat parser = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
                    return parser.format(parser.parse(dtFirm));
                }
                catch (ParseException e) {
                    return null;
                }
            }
            case 52: {
                return ((ReconyxHyperFire2MakernoteDirectory)this._directory).getString(tagType);
            }
            case 54: {
                int[] sequence = ((ReconyxHyperFire2MakernoteDirectory)this._directory).getIntArray(tagType);
                if (sequence == null) {
                    return null;
                }
                return String.format("%d/%d", sequence[0], sequence[1]);
            }
            case 58: {
                return String.format("%d", ((ReconyxHyperFire2MakernoteDirectory)this._directory).getInteger(tagType));
            }
            case 62: {
                String date = ((ReconyxHyperFire2MakernoteDirectory)this._directory).getString(tagType);
                try {
                    SimpleDateFormat parser = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
                    return parser.format(parser.parse(date));
                }
                catch (ParseException e) {
                    return null;
                }
            }
            case 74: {
                return this.getIndexedDescription(tagType, "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
            }
            case 76: {
                return this.getIndexedDescription(tagType, "New", "Waxing Crescent", "First Quarter", "Waxing Gibbous", "Full", "Waning Gibbous", "Last Quarter", "Waning Crescent");
            }
            case 78: 
            case 80: {
                return String.format("%d", ((ReconyxHyperFire2MakernoteDirectory)this._directory).getInteger(tagType));
            }
            case 82: 
            case 84: 
            case 86: 
            case 88: {
                return String.format("%d", ((ReconyxHyperFire2MakernoteDirectory)this._directory).getInteger(tagType));
            }
            case 90: {
                return this.getIndexedDescription(tagType, "Off", "On");
            }
            case 92: 
            case 94: {
                return String.format("%d", ((ReconyxHyperFire2MakernoteDirectory)this._directory).getInteger(tagType));
            }
            case 96: {
                return String.format("%d", ((ReconyxHyperFire2MakernoteDirectory)this._directory).getInteger(tagType));
            }
            case 98: 
            case 100: {
                Double value = ((ReconyxHyperFire2MakernoteDirectory)this._directory).getDoubleObject(tagType);
                DecimalFormat formatter = new DecimalFormat("0.000");
                return value == null ? null : formatter.format(value);
            }
            case 102: {
                return String.format("%d", ((ReconyxHyperFire2MakernoteDirectory)this._directory).getInteger(tagType));
            }
            case 104: {
                return ((ReconyxHyperFire2MakernoteDirectory)this._directory).getString(tagType);
            }
            case 126: {
                StringValue svalue = ((ReconyxHyperFire2MakernoteDirectory)this._directory).getStringValue(tagType);
                if (svalue == null) {
                    return null;
                }
                return svalue.toString();
            }
        }
        return super.getDescription(tagType);
    }
}

