/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.file;

import cn.allbs.metadata.imaging.FileType;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.Directory;
import cn.allbs.metadata.metadata.file.FileTypeDescriptor;
import java.util.HashMap;

public class FileTypeDirectory
extends Directory {
    public static final int TAG_DETECTED_FILE_TYPE_NAME = 1;
    public static final int TAG_DETECTED_FILE_TYPE_LONG_NAME = 2;
    public static final int TAG_DETECTED_FILE_MIME_TYPE = 3;
    public static final int TAG_EXPECTED_FILE_NAME_EXTENSION = 4;
    @NotNull
    private static final HashMap<Integer, String> _tagNameMap = new HashMap();

    public FileTypeDirectory(FileType fileType) {
        this.setDescriptor(new FileTypeDescriptor(this));
        this.setString(1, fileType.getName());
        this.setString(2, fileType.getLongName());
        if (fileType.getMimeType() != null) {
            this.setString(3, fileType.getMimeType());
        }
        if (fileType.getCommonExtension() != null) {
            this.setString(4, fileType.getCommonExtension());
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "File Type";
    }

    @Override
    @NotNull
    protected HashMap<Integer, String> getTagNameMap() {
        return _tagNameMap;
    }

    static {
        _tagNameMap.put(1, "Detected File Type Name");
        _tagNameMap.put(2, "Detected File Type Long Name");
        _tagNameMap.put(3, "Detected MIME Type");
        _tagNameMap.put(4, "Expected File Name Extension");
    }
}

