/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.heif;

import cn.allbs.metadata.imaging.heif.HeifHandler;
import cn.allbs.metadata.lang.RandomAccessStreamReader;
import cn.allbs.metadata.lang.SequentialByteArrayReader;
import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.exif.ExifReader;
import cn.allbs.metadata.metadata.heif.HeifDirectory;
import cn.allbs.metadata.metadata.heif.boxes.AuxiliaryTypeProperty;
import cn.allbs.metadata.metadata.heif.boxes.Box;
import cn.allbs.metadata.metadata.heif.boxes.ColourInformationBox;
import cn.allbs.metadata.metadata.heif.boxes.ImageRotationBox;
import cn.allbs.metadata.metadata.heif.boxes.ImageSpatialExtentsProperty;
import cn.allbs.metadata.metadata.heif.boxes.ItemInfoBox;
import cn.allbs.metadata.metadata.heif.boxes.ItemLocationBox;
import cn.allbs.metadata.metadata.heif.boxes.ItemProtectionBox;
import cn.allbs.metadata.metadata.heif.boxes.PixelInformationBox;
import cn.allbs.metadata.metadata.heif.boxes.PrimaryItemBox;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class HeifPictureHandler
extends HeifHandler<HeifDirectory> {
    private static final Set<String> boxesCanProcess = new HashSet<String>(Arrays.asList("ipro", "pitm", "iinf", "iloc", "ispe", "auxC", "irot", "colr", "pixi"));
    private static final Set<String> itemsCanProcess = new HashSet<String>(Collections.singletonList("Exif"));
    private static final Set<String> containersCanProcess = new HashSet<String>(Arrays.asList("iprp", "ipco", "mdat"));
    ItemProtectionBox itemProtectionBox;
    PrimaryItemBox primaryItemBox;
    ItemInfoBox itemInfoBox;
    ItemLocationBox itemLocationBox;

    public HeifPictureHandler(Metadata metadata) {
        super(metadata);
    }

    @Override
    protected boolean shouldAcceptBox(@NotNull Box box) {
        return boxesCanProcess.contains(box.type);
    }

    @Override
    protected boolean shouldAcceptContainer(@NotNull Box box) {
        return containersCanProcess.contains(box.type);
    }

    @Override
    protected HeifHandler<?> processBox(@NotNull Box box, @NotNull byte[] payload) throws IOException {
        SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
        if (box.type.equals("ipro")) {
            this.itemProtectionBox = new ItemProtectionBox(reader, box);
        } else if (box.type.equals("pitm")) {
            this.primaryItemBox = new PrimaryItemBox(reader, box);
        } else if (box.type.equals("iinf")) {
            this.itemInfoBox = new ItemInfoBox(reader, box);
            this.itemInfoBox.addMetadata(this.directory);
        } else if (box.type.equals("iloc")) {
            this.itemLocationBox = new ItemLocationBox(reader, box);
        } else if (box.type.equals("ispe")) {
            ImageSpatialExtentsProperty imageSpatialExtentsProperty = new ImageSpatialExtentsProperty(reader, box);
            imageSpatialExtentsProperty.addMetadata(this.directory);
        } else if (box.type.equals("auxC")) {
            AuxiliaryTypeProperty imageSpatialExtentsProperty = new AuxiliaryTypeProperty(reader, box);
        } else if (box.type.equals("irot")) {
            ImageRotationBox imageRotationBox = new ImageRotationBox(reader, box);
            imageRotationBox.addMetadata(this.directory);
        } else if (box.type.equals("colr")) {
            ColourInformationBox colourInformationBox = new ColourInformationBox(reader, box, this.metadata);
            colourInformationBox.addMetadata(this.directory);
        } else if (box.type.equals("pixi")) {
            PixelInformationBox pixelInformationBox = new PixelInformationBox(reader, box);
            pixelInformationBox.addMetadata(this.directory);
        }
        return this;
    }

    @Override
    protected void processContainer(@NotNull Box box, @NotNull SequentialReader reader) throws IOException {
        if (box.type.equals("mdat") && this.itemInfoBox != null && this.itemLocationBox != null) {
            for (ItemLocationBox.Extent extent : this.itemLocationBox.getExtents()) {
                ItemInfoBox.ItemInfoEntry infoEntry = this.itemInfoBox.getEntry(extent.getItemId());
                long bytesToSkip = extent.getOffset() - reader.getPosition();
                if (bytesToSkip > 0L) {
                    reader.skip(bytesToSkip);
                }
                if (!this.shouldHandleItem(infoEntry)) continue;
                this.handleItem(infoEntry, new SequentialByteArrayReader(reader.getBytes((int)extent.getLength())));
            }
        }
    }

    private boolean shouldHandleItem(ItemInfoBox.ItemInfoEntry infoEntry) {
        return itemsCanProcess.contains(infoEntry.getItemType());
    }

    private void handleItem(@NotNull ItemInfoBox.ItemInfoEntry entry, @NotNull SequentialByteArrayReader payloadReader) throws IOException {
        if (entry.getItemType().equals("Exif")) {
            long tiffHeaderOffset = payloadReader.getUInt32();
            if (tiffHeaderOffset > (long)payloadReader.available()) {
                return;
            }
            payloadReader.skip(tiffHeaderOffset);
            ByteArrayInputStream tiffStream = new ByteArrayInputStream(payloadReader.getBytes(payloadReader.available()));
            new ExifReader().extract(new RandomAccessStreamReader(tiffStream), this.metadata);
        }
    }

    @Override
    protected HeifDirectory getDirectory() {
        return new HeifDirectory();
    }
}

