/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.ico;

import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.ico.IcoDirectory;
import java.io.IOException;

public class IcoReader {
    public void extract(@NotNull SequentialReader reader, @NotNull Metadata metadata) {
        int imageCount;
        int type;
        reader.setMotorolaByteOrder(false);
        try {
            int reserved = reader.getUInt16();
            if (reserved != 0) {
                IcoDirectory directory = new IcoDirectory();
                directory.addError("Invalid header bytes");
                metadata.addDirectory(directory);
                return;
            }
            type = reader.getUInt16();
            if (type != 1 && type != 2) {
                IcoDirectory directory = new IcoDirectory();
                directory.addError("Invalid type " + type + " -- expecting 1 or 2");
                metadata.addDirectory(directory);
                return;
            }
            imageCount = reader.getUInt16();
            if (imageCount == 0) {
                IcoDirectory directory = new IcoDirectory();
                directory.addError("Image count cannot be zero");
                metadata.addDirectory(directory);
                return;
            }
        }
        catch (IOException ex) {
            IcoDirectory directory = new IcoDirectory();
            directory.addError("Exception reading ICO file metadata: " + ex.getMessage());
            metadata.addDirectory(directory);
            return;
        }
        for (int imageIndex = 0; imageIndex < imageCount; ++imageIndex) {
            IcoDirectory directory = new IcoDirectory();
            try {
                directory.setInt(1, type);
                directory.setInt(2, reader.getUInt8());
                directory.setInt(3, reader.getUInt8());
                directory.setInt(4, reader.getUInt8());
                reader.getUInt8();
                if (type == 1) {
                    directory.setInt(5, reader.getUInt16());
                    directory.setInt(7, reader.getUInt16());
                } else {
                    directory.setInt(6, reader.getUInt16());
                    directory.setInt(8, reader.getUInt16());
                }
                directory.setLong(9, reader.getUInt32());
                directory.setLong(10, reader.getUInt32());
            }
            catch (IOException ex) {
                directory.addError("Exception reading ICO file metadata: " + ex.getMessage());
            }
            metadata.addDirectory(directory);
        }
    }
}

