/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.jpeg;

import cn.allbs.metadata.imaging.jpeg.JpegSegmentMetadataReader;
import cn.allbs.metadata.imaging.jpeg.JpegSegmentType;
import cn.allbs.metadata.lang.SequentialByteArrayReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.ErrorDirectory;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.jpeg.JpegDirectory;
import java.io.IOException;
import java.util.Collections;

public class JpegDnlReader
implements JpegSegmentMetadataReader {
    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Collections.singletonList(JpegSegmentType.DNL);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> segments, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        for (byte[] segmentBytes : segments) {
            this.extract(segmentBytes, metadata, segmentType);
        }
    }

    public void extract(byte[] segmentBytes, Metadata metadata, JpegSegmentType segmentType) {
        JpegDirectory directory = metadata.getFirstDirectoryOfType(JpegDirectory.class);
        if (directory == null) {
            ErrorDirectory errorDirectory = new ErrorDirectory();
            metadata.addDirectory(errorDirectory);
            errorDirectory.addError("DNL segment found without SOFx - illegal JPEG format");
            return;
        }
        SequentialByteArrayReader reader = new SequentialByteArrayReader(segmentBytes);
        try {
            Integer i = directory.getInteger(1);
            if (i == null || i == 0) {
                directory.setInt(1, reader.getUInt16());
            }
        }
        catch (IOException ex) {
            directory.addError(ex.getMessage());
        }
    }
}

