/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.metadata.metadata.mov;

import cn.allbs.metadata.imaging.quicktime.QuickTimeHandler;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.mov.QuickTimeContext;
import cn.allbs.metadata.metadata.mov.media.QuickTimeMusicHandler;
import cn.allbs.metadata.metadata.mov.media.QuickTimeSoundHandler;
import cn.allbs.metadata.metadata.mov.media.QuickTimeSubtitleHandler;
import cn.allbs.metadata.metadata.mov.media.QuickTimeTextHandler;
import cn.allbs.metadata.metadata.mov.media.QuickTimeTimecodeHandler;
import cn.allbs.metadata.metadata.mov.media.QuickTimeVideoHandler;
import cn.allbs.metadata.metadata.mov.metadata.QuickTimeDataHandler;
import cn.allbs.metadata.metadata.mov.metadata.QuickTimeDirectoryHandler;

public class QuickTimeHandlerFactory {
    private static final String HANDLER_METADATA_DIRECTORY = "mdir";
    private static final String HANDLER_METADATA_DATA = "mdta";
    private static final String HANDLER_SOUND_MEDIA = "soun";
    private static final String HANDLER_VIDEO_MEDIA = "vide";
    private static final String HANDLER_TIMECODE_MEDIA = "tmcd";
    private static final String HANDLER_TEXT_MEDIA = "text";
    private static final String HANDLER_SUBTITLE_MEDIA = "sbtl";
    private static final String HANDLER_MUSIC_MEDIA = "musi";
    private QuickTimeHandler<?> caller;

    public QuickTimeHandlerFactory(QuickTimeHandler<?> caller) {
        this.caller = caller;
    }

    public QuickTimeHandler<?> getHandler(String type, Metadata metadata, QuickTimeContext context) {
        if (type.equals(HANDLER_METADATA_DIRECTORY)) {
            return new QuickTimeDirectoryHandler(metadata);
        }
        if (type.equals(HANDLER_METADATA_DATA)) {
            return new QuickTimeDataHandler(metadata);
        }
        if (type.equals(HANDLER_SOUND_MEDIA)) {
            return new QuickTimeSoundHandler(metadata, context);
        }
        if (type.equals(HANDLER_VIDEO_MEDIA)) {
            return new QuickTimeVideoHandler(metadata, context);
        }
        if (type.equals(HANDLER_TIMECODE_MEDIA)) {
            return new QuickTimeTimecodeHandler(metadata, context);
        }
        if (type.equals(HANDLER_TEXT_MEDIA)) {
            return new QuickTimeTextHandler(metadata, context);
        }
        if (type.equals(HANDLER_SUBTITLE_MEDIA)) {
            return new QuickTimeSubtitleHandler(metadata, context);
        }
        if (type.equals(HANDLER_MUSIC_MEDIA)) {
            return new QuickTimeMusicHandler(metadata, context);
        }
        return this.caller;
    }
}

